/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.jlr;

import java.lang.reflect.Method;
import java.util.Arrays;

class MethodSignature {
    private final String name;
    private final Class<?>[] parameterTypes;

    public MethodSignature(Method method) {
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    public MethodSignature(String methodName, Class ... parameterTypes) {
        this.name = methodName;
        this.parameterTypes = parameterTypes;
    }

    public String getName() {
        return this.name;
    }

    public Method getDeclaredMethod(Class declaringClass) {
        try {
            return declaringClass.getDeclaredMethod(this.name, this.parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodSignature) {
            MethodSignature that = (MethodSignature)obj;
            return this.name.equals(that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
    }
}

