/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class UpgradeUsersFolderPlugin
extends UpgradeProductPlugin {
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeUsersFolderPlugin.class.getName());
    private NodeHierarchyCreator nodeHCreator_;
    private OrganizationService orgService_;

    public UpgradeUsersFolderPlugin(OrganizationService orgService, NodeHierarchyCreator nodeHCreator, RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.nodeHCreator_ = nodeHCreator;
        this.orgService_ = orgService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Starting upgrade permisson for Users folder");
        }
        this.upgradePermissionForUserFolder();
        try {
            this.upgradePermissionForChildren();
        }
        catch (Exception e) {
            LOG.error((Object)"Upgrade FAILED! Unexpected problem happens", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Finished upgrade permission for Users Folder");
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePermissionForUserFolder() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String superUser = ((UserACL)WCMCoreUtils.getService(UserACL.class)).getSuperUser();
        try {
            String defaultWSName = this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Node usersFolder = (Node)sessionProvider.getSession(defaultWSName, this.repoService_.getCurrentRepository()).getItem(this.nodeHCreator_.getJcrPath("usersPath"));
            ArrayList<String> persList = new ArrayList<String>(4);
            persList.add("read");
            persList.add("add_node");
            persList.add("set_property");
            persList.add("remove");
            ((ExtendedNode)usersFolder).setPermission(superUser, persList.toArray(new String[persList.size()]));
            sessionProvider.getSession(defaultWSName, this.repoService_.getCurrentRepository()).save();
        }
        catch (PathNotFoundException e) {
            LOG.error((Object)"Upgrade FAILED! Users folder can not be found", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.error((Object)"Upgrade failed! Cannot login into system", (Throwable)e);
        }
        catch (NoSuchWorkspaceException e) {
            LOG.error((Object)"Upgrade FAILED! The default workspace cannot be found", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Upgrade FAILED! Unexpected problem happens", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePermissionForChildren() throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String defaultWSName = this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        try {
            WCMCoreUtils.startRequest((OrganizationService)this.orgService_);
            ListAccess userListAccess = this.orgService_.getUserHandler().findAllUsers();
            List userList = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)userListAccess);
            for (User user : userList) {
                String userName = user.getUserName();
                Node userNode = this.nodeHCreator_.getUserNode(sessionProvider, userName);
                NodeIterator nodeIter = userNode.getNodes();
                while (nodeIter.hasNext()) {
                    NodeImpl nodeImpl = (NodeImpl)nodeIter.next();
                    try {
                        nodeImpl.removePermission(userName, "remove");
                    }
                    catch (AccessControlException ace) {}
                }
                userNode.save();
            }
        }
        catch (Exception e) {
            sessionProvider.getSession(defaultWSName, this.repoService_.getCurrentRepository()).refresh(false);
            LOG.error((Object)"MIGRATION DIDN'T SUCCESSED", (Throwable)e);
        }
        finally {
            WCMCoreUtils.endRequest((OrganizationService)this.orgService_);
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }
}

