/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.state;

import java.util.Map;
import javax.xml.namespace.QName;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.state.AbstractContextualPropertyProviderPlugin;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicPropertiesPlugin
extends AbstractContextualPropertyProviderPlugin {
    private final QName navigationURIQName;
    private final QName pageNameQName;
    private final QName siteTypeQName;
    private final QName siteNameQName;
    private final QName windowShowInfoBarQName;
    private final QName windowHeight;
    private final QName windowWidth;

    public PublicPropertiesPlugin(InitParams params) throws Exception {
        super(params);
        this.navigationURIQName = new QName(this.namespaceURI, "navigation_uri");
        this.pageNameQName = new QName(this.namespaceURI, "page_name");
        this.siteTypeQName = new QName(this.namespaceURI, "site_type");
        this.siteNameQName = new QName(this.namespaceURI, "site_name");
        this.windowWidth = new QName(this.namespaceURI, "window_width");
        this.windowHeight = new QName(this.namespaceURI, "window_height");
        this.windowShowInfoBarQName = new QName(this.namespaceURI, "window_show_info_bar");
    }

    @Override
    public void getProperties(UIPortlet portletWindow, Map<QName, String[]> properties) {
        try {
            UIPortal currentSite = Util.getUIPortalApplication().getCurrentSite();
            UserNode currentNode = currentSite.getSelectedUserNode();
            this.addProperty(properties, this.navigationURIQName, currentNode.getURI());
            UIPage currentPage = currentSite.getUIPage(currentNode.getPageRef());
            if (currentPage != null) {
                this.addProperty(properties, this.pageNameQName, currentPage.getTitle());
            }
            this.addProperty(properties, this.siteTypeQName, currentSite.getSiteType().getName());
            this.addProperty(properties, this.siteNameQName, currentSite.getName());
            this.addProperty(properties, this.windowShowInfoBarQName, Boolean.toString(portletWindow.getShowInfoBar()));
            this.addProperty(properties, this.windowWidth, portletWindow.getWidth());
            this.addProperty(properties, this.windowHeight, portletWindow.getHeight());
        }
        catch (Exception ex) {
            this.log.error((Object)("Could not obtain contextual properties for portlet " + (Object)((Object)portletWindow)), (Throwable)ex);
        }
    }
}

