/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.deployment.WCMContentInitializerService;
import org.exoplatform.services.deployment.plugins.XMLDeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.NodeTypeRecognizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeContentPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeContentPlugin.class);
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private List<DeploymentDescriptor> deploymentDescriptors = new ArrayList<DeploymentDescriptor>();
    private Map<String, XMLDeploymentPlugin> deploymentPlugins = new HashMap<String, XMLDeploymentPlugin>();
    private List<String> webappsNames = new ArrayList<String>();

    public UpgradeContentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService) throws Exception {
        super(initParams);
        Component wcmContentInitializerServiceComponent;
        ArrayList plugins;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
        if (initParams.containsKey((Object)"webapps-mames")) {
            this.webappsNames = initParams.getValuesParam("webapps-mames").getValues();
        }
        if ((plugins = (wcmContentInitializerServiceComponent = configurationManager.getComponent(WCMContentInitializerService.class)).getComponentPlugins()) == null) {
            plugins = new ArrayList();
        }
        ExternalComponentPlugins externalComponentPlugins = configurationManager.getConfiguration().getExternalComponentPlugins(WCMContentInitializerService.class.getName());
        plugins.addAll(externalComponentPlugins.getComponentPlugins());
        for (ComponentPlugin plugin : plugins) {
            InitParams pluginInitParams;
            Iterator objectParamIterator;
            if (!plugin.getType().equals(XMLDeploymentPlugin.class.getName()) || plugin.getInitParams() == null || (objectParamIterator = (pluginInitParams = plugin.getInitParams()).getObjectParamIterator()) == null) continue;
            while (objectParamIterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)objectParamIterator.next();
                DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
                this.deploymentDescriptors.add(deploymentDescriptor);
                InitParams params = new InitParams();
                params.addParameter((Parameter)objectParameter);
                String key = this.getMapKey(deploymentDescriptor);
                XMLDeploymentPlugin deploymentPlugin = new XMLDeploymentPlugin(params, configurationManager, repositoryService);
                deploymentPlugin.setName(plugin.getName());
                this.deploymentPlugins.put(key, deploymentPlugin);
            }
        }
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        ManageableRepository repository = null;
        try {
            repository = this.repositoryService.getCurrentRepository();
        }
        catch (RepositoryException exception1) {
            throw new IllegalStateException("Could not retrieve current repository. Contents upgrade is canceled.");
        }
        for (DeploymentDescriptor deploymentDescriptor : this.deploymentDescriptors) {
            Session session = null;
            try {
                Node node;
                if (!this.shouldDeploy(deploymentDescriptor)) {
                    this.deploymentPlugins.remove(this.getMapKey(deploymentDescriptor));
                    continue;
                }
                InputStream inputStream = this.configurationManager.getInputStream(deploymentDescriptor.getSourcePath());
                String nodeName = this.getNodeName(inputStream);
                session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
                if (!session.itemExists(deploymentDescriptor.getTarget().getNodePath())) {
                    LOG.warn((Object)(deploymentDescriptor.getTarget().getNodePath() + " doesn't exist, could not import " + deploymentDescriptor.getSourcePath()));
                }
                if (!(node = (Node)session.getItem(deploymentDescriptor.getTarget().getNodePath())).hasNode(nodeName)) continue;
                LOG.info((Object)("Deleting nodes " + deploymentDescriptor.getTarget().getNodePath() + "/" + nodeName + " to be replaced by " + deploymentDescriptor.getSourcePath()));
                NodeIterator nodeIterator = node.getNodes(nodeName);
                while (nodeIterator.hasNext()) {
                    Node targetNode = nodeIterator.nextNode();
                    LOG.info((Object)("  - Remove " + targetNode.getPath()));
                    targetNode.remove();
                }
                String key = this.getMapKey(deploymentDescriptor);
                XMLDeploymentPlugin deploymentPlugin = this.deploymentPlugins.remove(key);
                deploymentPlugin.deploy(sessionProvider);
                session.save();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Can't read stream from " + deploymentDescriptor.getSourcePath(), exception);
            }
            finally {
                if (session == null || !session.isLive()) continue;
                session.logout();
            }
        }
        Collection<XMLDeploymentPlugin> remainingDeploymentPlugins = this.deploymentPlugins.values();
        for (XMLDeploymentPlugin deploymentPlugin : remainingDeploymentPlugins) {
            try {
                deploymentPlugin.deploy(sessionProvider);
            }
            catch (Exception exception) {
                LOG.error((Object)("Can't proceed to content deployment of deploymentPlugin : " + deploymentPlugin.getName()), (Throwable)exception);
            }
        }
    }

    private boolean shouldDeploy(DeploymentDescriptor deploymentDescriptor) {
        if (this.webappsNames.isEmpty()) {
            return true;
        }
        try {
            URL url = this.configurationManager.getResource(deploymentDescriptor.getSourcePath());
            String path = url.getPath();
            for (String webapp : this.webappsNames) {
                if (!path.contains("/" + webapp + "/WEB-INF/")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("An error occured while upgrading :" + deploymentDescriptor.getSourcePath()), (Throwable)exception);
        }
        return false;
    }

    private String getMapKey(DeploymentDescriptor deploymentDescriptor) {
        return deploymentDescriptor.getTarget().getWorkspace() + deploymentDescriptor.getTarget().getNodePath() + deploymentDescriptor.getSourcePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getNodeName(InputStream stream) throws Exception {
        String nodeToImportName = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        try {
            reader = factory.createXMLEventReader(stream);
            XMLEvent event = null;
            do {
                event = reader.nextEvent();
            } while (reader.hasNext() && event.getEventType() != 1);
            if (event.getEventType() != 1) {
                throw new IllegalStateException("Content isn't lisible");
            }
            StartElement element = event.asStartElement();
            QName name = element.getName();
            switch (NodeTypeRecognizer.recognize((String)name.getNamespaceURI(), (String)(name.getPrefix() + ":" + name.getLocalPart()))) {
                case DOCVIEW: {
                    if (name.getPrefix() == null || name.getPrefix().isEmpty()) {
                        nodeToImportName = ISO9075.decode((String)name.getLocalPart());
                        return nodeToImportName;
                    } else {
                        nodeToImportName = ISO9075.decode((String)(name.getPrefix() + ":" + name.getLocalPart()));
                        return nodeToImportName;
                    }
                }
                case SYSVIEW: {
                    Iterator<Attribute> attributes = element.getAttributes();
                    while (attributes.hasNext() && nodeToImportName == null) {
                        Attribute attribute = attributes.next();
                        if (!(attribute.getName().getNamespaceURI() + ":" + attribute.getName().getLocalPart()).equals(Constants.SV_NAME_NAME.getNamespace() + ":" + Constants.SV_NAME_NAME.getName())) continue;
                        nodeToImportName = attribute.getValue();
                        return nodeToImportName;
                    }
                    return nodeToImportName;
                }
                default: {
                    throw new IllegalStateException("There was an error during ascertaining the type of document. First element ");
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
                stream.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

