/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.io.InputStream;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.core.ExtendedNamespaceRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeNamespaceJosPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeNamespaceJosPlugin.class);
    private RepositoryService repositoryService;
    private ConfigurationManager configurationManager;

    public UpgradeNamespaceJosPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService) throws Exception {
        super(initParams);
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start UpgradeNamespaceJosPlugin ...");
        try {
            ExtendedNamespaceRegistry namespaceRegistry = (ExtendedNamespaceRegistry)this.repositoryService.getCurrentRepository().getNamespaceRegistry();
            ExtendedNodeTypeManager nodeTypeManager = this.repositoryService.getCurrentRepository().getNodeTypeManager();
            String oldNamespaceURL = namespaceRegistry.getNamespaceURIByPrefix("jos");
            if (!oldNamespaceURL.equalsIgnoreCase("http://www.exoplatform.com/jcr-services/organization-service/1.0/")) {
                boolean hasNodeType = false;
                try {
                    namespaceRegistry.unregisterNamespace("jos");
                    namespaceRegistry.registerNamespace("jos", "http://www.exoplatform.com/jcr-services/organization-service/1.0/");
                }
                catch (Exception e) {
                    hasNodeType = true;
                    LOG.info((Object)"Need unregister nodetypes first...");
                }
                if (hasNodeType) {
                    try {
                        nodeTypeManager.unregisterNodeType("jos:membershipType");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:membershipType does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:userMembership");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:userMembership does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:profileAttributes");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:profileAttributes does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:userProfile");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:userMembership does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:user");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:user does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:hierarchyGroup");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:hierarchyGroup does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:organizationUsers");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:userMembership does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:organizationGroups");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:organizationGroups does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:organizationMembershipTypes");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:organizationMembershipTypes does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:organizationStorage");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:organizationStorage does not exist...");
                    }
                    try {
                        nodeTypeManager.unregisterNodeType("jos:group");
                    }
                    catch (Exception e) {
                        LOG.info((Object)"jos:group does not exist...");
                    }
                    namespaceRegistry.unregisterNamespace("jos");
                    namespaceRegistry.registerNamespace("jos", "http://www.exoplatform.com/jcr-services/organization-service/1.0/");
                    InputStream inputStream = this.configurationManager.getInputStream("jar:/conf/organization-nodetypes.xml");
                    nodeTypeManager.registerNodeTypes(inputStream, 4, "text/xml");
                }
                LOG.info((Object)"Perform UpgradeNamespaceJosPlugin done...");
            } else {
                LOG.info((Object)"Nothing to run UpgradeNamespaceJosPlugin ...");
            }
            LOG.info((Object)"Finish UpgradeNamespaceJosPlugin ...");
        }
        catch (Exception e) {
            LOG.error((Object)"UpgradeNamespaceJosPlugin: Upgrade Jos namespace failure", (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

