/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.exoplatform.commons.utils.SecurityHelper;

public class InspectionReport {
    private static final String COMMENT = "//";
    private static final String DELIMITER = "\n";
    private static final String WHITE_SPACE = " ";
    private Writer writer;
    private boolean reportHasInconsistency;
    private String reportPath;

    public InspectionReport(String forRepository) throws IOException {
        final File reportFile = new File("report-" + forRepository + "-" + new SimpleDateFormat("dd-MMM-yy-HH-mm").format(new Date()) + ".txt");
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                InspectionReport.this.reportPath = reportFile.getAbsolutePath();
                InspectionReport.this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(reportFile)));
                return null;
            }
        });
    }

    public boolean hasInconsistency() {
        return this.reportHasInconsistency;
    }

    public void logComment(String message) throws IOException {
        this.writeLine(message);
        this.writer.flush();
    }

    public void logDescription(String description) throws IOException {
        this.writeLine(description);
        this.writer.flush();
    }

    public void logBrokenObjectAndSetInconsistency(String brokenObject) throws IOException {
        this.setInconsistency();
        this.writer.write(brokenObject);
        this.writer.write(DELIMITER);
        this.writer.flush();
    }

    public void logExceptionAndSetInconsistency(String message, Throwable e) throws IOException {
        this.setInconsistency();
        this.writeLine(message);
        this.writeStackTrace(e);
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public String getReportPath() {
        return this.reportPath;
    }

    private void setInconsistency() {
        this.reportHasInconsistency = true;
    }

    private void writeLine(String message) throws IOException {
        this.writer.write(COMMENT);
        this.writer.write(message);
        this.writer.write(DELIMITER);
        this.writer.flush();
    }

    private void writeStackTrace(Throwable e) throws IOException {
        this.writeLine(e.getMessage());
        this.writeLine(e.toString());
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            this.writeLine("\tat " + trace[i]);
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            this.writeLine("Cause:");
            this.writeStackTrace(ourCause);
        }
    }
}

