/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.lucene.index.Term;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexMerger
extends Thread
implements IndexListener {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.IndexMerger");
    private static final Merge QUIT = new Merge(new Index[0]);
    private int minMergeDocs = 100;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private final Buffer mergeTasks = BufferUtils.blockingBuffer((Buffer)new UnboundedFifoBuffer());
    private final List deletedDocuments = Collections.synchronizedList(new ArrayList());
    private final List indexBuckets = new ArrayList();
    private final MultiIndex multiIndex;
    private final Object lock = new Object();
    private final Sync indexReplacement = new Mutex();
    private final Sync mergerIdle = new Mutex();

    IndexMerger(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
        this.setName("Index Merger" + (multiIndex.workspaceId == null ? "" : " " + multiIndex.workspaceId));
        this.setDaemon(true);
        try {
            this.mergerIdle.acquire();
        }
        catch (InterruptedException e) {
            throw new InternalError("Unable to acquire mutex after construction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexAdded(String name, int numDocs) {
        if (numDocs < 0) {
            throw new IllegalArgumentException("numDocs must be positive");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.indexBuckets.size() == 0) {
                long lower = 0L;
                for (long upper = (long)this.minMergeDocs; upper < (long)this.maxMergeDocs; upper *= (long)this.mergeFactor) {
                    this.indexBuckets.add(new IndexBucket(lower, upper, true));
                    lower = upper + 1L;
                }
                this.indexBuckets.add(new IndexBucket(lower, this.maxMergeDocs, false));
                this.indexBuckets.add(new IndexBucket(this.maxMergeDocs + 1, Long.MAX_VALUE, false));
            }
            IndexBucket bucket = (IndexBucket)this.indexBuckets.get(this.indexBuckets.size() - 1);
            for (int i = 0; i < this.indexBuckets.size() && !(bucket = (IndexBucket)this.indexBuckets.get(i)).fits(numDocs); ++i) {
            }
            bucket.add(new Index(name, numDocs));
            if (log.isDebugEnabled()) {
                log.debug("index added: name=" + name + ", numDocs=" + numDocs);
            }
            if (!bucket.allowsMerge()) {
                return;
            }
            if (bucket.size() >= this.mergeFactor) {
                long targetMergeDocs = bucket.upper;
                targetMergeDocs = Math.min(targetMergeDocs * (long)this.mergeFactor, (long)this.maxMergeDocs);
                ArrayList indexesToMerge = new ArrayList();
                int mergeDocs = 0;
                Iterator it = bucket.iterator();
                while (it.hasNext() && (long)mergeDocs <= targetMergeDocs) {
                    indexesToMerge.add(it.next());
                }
                if (indexesToMerge.size() > 2) {
                    Index[] idxs = indexesToMerge.toArray(new Index[indexesToMerge.size()]);
                    bucket.removeAll(indexesToMerge);
                    if (log.isDebugEnabled()) {
                        log.debug("requesting merge for " + indexesToMerge);
                    }
                    this.mergeTasks.add((Object)new Merge(idxs));
                    log.debug("merge queue now contains " + this.mergeTasks.size() + " tasks.");
                }
            }
        }
    }

    public void documentDeleted(Term id) {
        log.debug("document deleted: " + id.text());
        this.deletedDocuments.add(id);
    }

    void waitUntilIdle() throws InterruptedException {
        this.mergerIdle.acquire();
        this.mergerIdle.release();
    }

    void dispose() {
        log.debug("dispose IndexMerger");
        try {
            this.indexReplacement.acquire();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while acquiring index replacement sync: " + e);
        }
        this.mergeTasks.clear();
        this.mergeTasks.add((Object)QUIT);
        log.debug("quit sent");
        try {
            this.join(500L);
            if (this.isAlive()) {
                log.info("Unable to stop IndexMerger. Daemon is busy.");
            } else {
                log.debug("IndexMerger thread stopped");
            }
            log.debug("merge queue size: " + this.mergeTasks.size());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for IndexMerger thread to terminate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            isIdle = false;
            if (this.mergeTasks.size() == 0) {
                this.mergerIdle.release();
                isIdle = true;
            }
            if ((task = (Merge)this.mergeTasks.remove()) == IndexMerger.QUIT) {
                this.mergerIdle.release();
                break;
            }
            if (isIdle) {
                try {
                    this.mergerIdle.acquire();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    IndexMerger.log.warn("Unable to acquire mergerIdle sync");
                }
            }
            IndexMerger.log.debug("accepted merge request");
            this.deletedDocuments.clear();
            names = new String[Merge.access$100(task).length];
            for (i = 0; i < Merge.access$100(task).length; ++i) {
                names[i] = Index.access$200(Merge.access$100(task)[i]);
            }
            try {
                block25: {
                    block24: {
                        IndexMerger.log.debug("create new index");
                        index = this.multiIndex.getOrCreateIndex(null);
                        success = false;
                        try {
                            IndexMerger.log.debug("get index readers from MultiIndex");
                            readers = this.multiIndex.getIndexReaders(names, this);
                            try {
                                time = System.currentTimeMillis();
                                index.addIndexes(readers);
                                time = System.currentTimeMillis() - time;
                                docCount = 0;
                                for (i = 0; i < readers.length; docCount += readers[i].numDocs(), ++i) {
                                }
                                IndexMerger.log.info("merged " + docCount + " documents in " + time + " ms into " + index.getName() + ".");
                                var12_13 = null;
                            }
                            catch (Throwable var11_18) {
                                var12_13 = null;
                                i = 0;
                                while (true) {
                                    block27: {
                                        if (i >= readers.length) {
                                            throw var11_18;
                                        }
                                        ** try [egrp 4[TRYBLOCK] [3 : 329->340)] { 
lbl56:
                                        // 1 sources

                                        Util.closeOrRelease(readers[i]);
                                        break block27;
lbl58:
                                        // 1 sources

                                        catch (IOException e) {
                                            IndexMerger.log.warn("Unable to close IndexReader: " + e);
                                        }
                                    }
                                    ++i;
                                }
                            }
                            for (i = 0; i < readers.length; ++i) {
                                try {
                                    Util.closeOrRelease(readers[i]);
                                    continue;
                                }
                                catch (IOException e) {
                                    IndexMerger.log.warn("Unable to close IndexReader: " + e);
                                }
                            }
                            if (!this.indexReplacement.attempt(0L)) {
                                IndexMerger.log.debug("index merging canceled");
                                index.close();
                                var18_17 = null;
                                if (success) break;
                                break block24;
                            }
                            try {
                                IndexMerger.log.debug("replace indexes");
                                this.multiIndex.replaceIndexes(names, index, this.deletedDocuments);
                                var16_16 = null;
                            }
                            catch (Throwable var15_19) {
                                var16_16 = null;
                                this.indexReplacement.release();
                                throw var15_19;
                            }
                            this.indexReplacement.release();
                            success = true;
                            break block25;
                        }
                        catch (Throwable var17_20) {
                            var18_17 = null;
                            if (!success) {
                                IndexMerger.log.debug("deleting index " + index.getName());
                                this.multiIndex.deleteIndex(index);
                            }
                            throw var17_20;
                        }
                    }
                    IndexMerger.log.debug("deleting index " + index.getName());
                    this.multiIndex.deleteIndex(index);
                    break;
                }
                var18_17 = null;
                if (success) continue;
                IndexMerger.log.debug("deleting index " + index.getName());
                this.multiIndex.deleteIndex(index);
            }
            catch (Throwable e) {
                IndexMerger.log.error("Error while merging indexes: ", e);
            }
        }
        IndexMerger.log.info("IndexMerger terminated");
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    private static final class IndexBucket
    extends ArrayList {
        private final long lower;
        private final long upper;
        private final boolean allowMerge;

        IndexBucket(long lower, long upper, boolean allowMerge) {
            this.lower = lower;
            this.upper = upper;
            this.allowMerge = allowMerge;
        }

        boolean fits(long numDocs) {
            return numDocs >= this.lower && numDocs <= this.upper;
        }

        boolean allowsMerge() {
            return this.allowMerge;
        }
    }

    private static final class Merge {
        private final Index[] indexes;

        Merge(Index[] indexes) {
            this.indexes = new Index[indexes.length];
            System.arraycopy(indexes, 0, this.indexes, 0, indexes.length);
        }

        static /* synthetic */ Index[] access$100(Merge x0) {
            return x0.indexes;
        }
    }

    private static final class Index
    implements Comparable {
        private final String name;
        private final int numDocs;

        Index(String name, int numDocs) {
            this.name = name;
            this.numDocs = numDocs;
        }

        public int compareTo(Object o) {
            int val;
            Index other = (Index)o;
            int n = this.numDocs < other.numDocs ? -1 : (val = this.numDocs == other.numDocs ? 0 : 1);
            if (val != 0) {
                return val;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name + ":" + this.numDocs;
        }

        static /* synthetic */ String access$200(Index x0) {
            return x0.name;
        }
    }
}

