/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    public HSQLDBSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    @Override
    protected final void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_ITEM_BY_NAME = "select * from JCR_SITEM where PARENT_ID=? and CONTAINER_NAME=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=? order by N_ORDER_NUM";
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_SITEM where PARENT_ID=? and I_CLASS=2 and CONTAINER_NAME=? order by ID";
        this.FIND_NODES_BY_PARENTID_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SITEM P, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=1 and I.CONTAINER_NAME=? and P.PARENT_ID=I.ID and P.I_CLASS=2 and P.CONTAINER_NAME=? and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        this.FIND_PROPERTIES_BY_PARENTID_CQ = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_SITEM I LEFT OUTER JOIN JCR_SVALUE V ON (V.PROPERTY_ID=I.ID) where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? order by I.NAME";
    }

    @Override
    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        return this.traverseQPathSQ(cpid);
    }

    @Override
    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, parentId);
        this.findItemByName.setString(2, this.containerName);
        this.findItemByName.setString(3, name);
        this.findItemByName.setInt(4, index);
        return this.findItemByName.executeQuery();
    }

    @Override
    protected ResultSet findPropertyByName(String parentCid, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, parentCid);
        this.findPropertyByName.setString(2, this.containerName);
        this.findPropertyByName.setString(3, name);
        return this.findPropertyByName.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, parentCid);
        this.findNodesByParentId.setString(2, this.containerName);
        return this.findNodesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        } else {
            this.findLastOrderNumberByParentId.clearParameters();
        }
        this.findLastOrderNumberByParentId.setString(1, parentIdentifier);
        this.findLastOrderNumberByParentId.setString(2, this.containerName);
        return this.findLastOrderNumberByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesCountByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, parentCid);
        this.findNodesCountByParentId.setString(2, this.containerName);
        return this.findNodesCountByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, parentCid);
        this.findPropertiesByParentId.setString(2, this.containerName);
        return this.findPropertiesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodesByParentIdCQ == null) {
            this.findNodesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_CQ);
        } else {
            this.findNodesByParentIdCQ.clearParameters();
        }
        this.findNodesByParentIdCQ.setString(1, parentIdentifier);
        this.findNodesByParentIdCQ.setString(2, this.containerName);
        this.findNodesByParentIdCQ.setString(3, this.containerName);
        return this.findNodesByParentIdCQ.executeQuery();
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        return this.getDirectChildNodesData(parent, itemDataFilters);
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findNodesByParentIdAndComplexPatternCQ == null) {
            this.findNodesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.PARENT_ID='");
        query.append(parentIdentifier);
        query.append("' and I.I_CLASS=1 and I.CONTAINER_NAME='");
        query.append(this.containerName);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), true);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), true);
        }
        query.append(" ) and P.PARENT_ID=I.ID and P.I_CLASS=2 and P.CONTAINER_NAME='");
        query.append(this.containerName);
        query.append("' and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType'");
        query.append(" or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')");
        query.append(" and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID");
        return this.findNodesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        return this.getDirectChildPropertiesData(parent, itemDataFilters);
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findPropertiesByParentIdCQ == null) {
            this.findPropertiesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findPropertiesByParentIdCQ.clearParameters();
        }
        this.findPropertiesByParentIdCQ.setString(1, parentIdentifier);
        this.findPropertiesByParentIdCQ.setString(2, this.containerName);
        return this.findPropertiesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentCid, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findPropertiesByParentIdAndComplexPatternCQ == null) {
            this.findPropertiesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.PARENT_ID='");
        query.append(parentCid);
        query.append("' and I.I_CLASS=2 and I.CONTAINER_NAME='");
        query.append(this.containerName);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), false);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), false);
        }
        query.append(" ) order by I.NAME");
        return this.findPropertiesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }
}

