/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedAction;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBInitializerHelper {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBInitializerHelper");
    public static String SQL_DELIMITER = ";";
    public static String SQL_DELIMITER_COMMENT_PREFIX = "/*$DELIMITER:";

    public static String scriptPath(String dbDialect, boolean multiDb) {
        String sqlPath = null;
        sqlPath = dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.ora.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.ora.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_PGSQL) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.pgsql.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.mysql.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_MYISAM) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.mysql-myisam.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.mysql-utf8.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_MYISAM_UTF8) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.mysql-myisam-utf8.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MSSQL) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.mssql.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_DERBY) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.derby.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_DB2) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.db2.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_DB2V8) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.db2v8.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.sybase.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_INGRES) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.ingres.sql" : (dbDialect.equalsIgnoreCase(DBConstants.DB_DIALECT_HSQLDB) ? "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.sql" : "/conf/storage/jcr-" + (multiDb ? "m" : "s") + "jdbc.sql")))))))))))));
        return sqlPath;
    }

    public static String validateDialect(String confParam) {
        for (String dbType : DBConstants.DB_DIALECTS) {
            if (!dbType.equalsIgnoreCase(confParam)) continue;
            return dbType;
        }
        return DBConstants.DB_DIALECT_GENERIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readScriptResource(final String path) throws IOException {
        String string;
        PrivilegedAction<InputStream> action = new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return this.getClass().getResourceAsStream(path);
            }
        };
        final InputStream is = (InputStream)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        PrivilegedAction<InputStreamReader> actionGetReader = new PrivilegedAction<InputStreamReader>(){

            @Override
            public InputStreamReader run() {
                return new InputStreamReader(is);
            }
        };
        InputStreamReader isr = (InputStreamReader)SecurityHelper.doPrivilegedAction((PrivilegedAction)actionGetReader);
        try {
            StringBuilder sbuff = new StringBuilder();
            char[] buff = new char[is.available()];
            int r = 0;
            while ((r = isr.read(buff)) > 0) {
                sbuff.append(buff, 0, r);
            }
            string = sbuff.toString();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                is.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return string;
    }

    public static String[] scripts(String script) {
        if (script.startsWith(SQL_DELIMITER_COMMENT_PREFIX)) {
            try {
                String s = script.substring(SQL_DELIMITER_COMMENT_PREFIX.length());
                int endOfDelimIndex = s.indexOf("*/");
                String delim = s.substring(0, endOfDelimIndex).trim();
                s = s.substring(endOfDelimIndex + 2).trim();
                return s.split(delim);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.warn((Object)("Error of parse SQL-script file. Invalid DELIMITER configuration. Valid format is '" + SQL_DELIMITER_COMMENT_PREFIX + "XXX*/' at begin of the SQL-script file, where XXX - DELIMITER string." + " Spaces will be trimed. "), (Throwable)e);
                LOG.info((Object)("Using DELIMITER:[" + SQL_DELIMITER + "]"));
                return script.split(SQL_DELIMITER);
            }
        }
        return script.split(SQL_DELIMITER);
    }

    public static String getRootNodeInitializeScript(boolean multiDb) {
        return "insert into JCR_" + (multiDb ? "M" : "S") + "ITEM(ID, PARENT_ID, NAME, " + (multiDb ? "" : "CONTAINER_NAME, ") + "VERSION, I_CLASS, I_INDEX, N_ORDER_NUM)" + " VALUES('" + Constants.ROOT_PARENT_UUID + "', '" + Constants.ROOT_PARENT_UUID + "', '" + "__root_parent" + "', " + (multiDb ? "" : "'__root_parent_container', ") + "0, 0, 0, 0)";
    }

    public static String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }

    public static String getObjectScript(String objectName, boolean multiDb, String dialect) throws RepositoryConfigurationException {
        String script;
        String scriptsPath = DBInitializerHelper.scriptPath(dialect, multiDb);
        try {
            script = DBInitializerHelper.readScriptResource(scriptsPath);
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Can not read script file " + scriptsPath, e);
        }
        String sql = null;
        for (String query : DBInitializerHelper.scripts(script)) {
            String q = DBInitializerHelper.cleanWhitespaces(query);
            if (!q.contains(objectName)) continue;
            if (sql != null) {
                throw new RepositoryConfigurationException("Can't find unique script for object creation. Object name: " + objectName);
            }
            sql = q;
        }
        if (sql != null) {
            return sql;
        }
        throw new RepositoryConfigurationException("Script for object creation is not found. Object name: " + objectName);
    }
}

