/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class AttachmentReference
extends EntityReference {
    public AttachmentReference(EntityReference reference) {
        super(reference);
    }

    protected AttachmentReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public AttachmentReference(String fileName, DocumentReference parent) {
        super(fileName, EntityType.ATTACHMENT, (EntityReference)parent);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof DocumentReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in an attachment reference");
        }
        super.setParent(new DocumentReference(parent));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.ATTACHMENT) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an attachment reference");
        }
        super.setType(EntityType.ATTACHMENT);
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.extractReference(EntityType.DOCUMENT);
    }

    @Override
    public AttachmentReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new AttachmentReference(this, oldParent, newParent);
    }
}

