/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.io.Writer;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public abstract class UIApplication
extends UIContainer {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIApplication");
    private String owner;
    private long lastAccessApplication_;
    private UIPopupMessages uiPopupMessages_;
    private static final String UIAPPLICATION = "uiapplication";

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String s) {
        this.owner = s;
    }

    public UIPopupMessages getUIPopupMessages() {
        if (this.uiPopupMessages_ == null) {
            try {
                this.uiPopupMessages_ = this.createUIComponent(UIPopupMessages.class, null, null);
                this.uiPopupMessages_.setId("_" + this.uiPopupMessages_.hashCode());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.uiPopupMessages_;
    }

    public void addMessage(ApplicationMessage message) {
        this.getUIPopupMessages().addMessage(message);
    }

    public void clearMessages() {
        this.getUIPopupMessages().clearMessages();
    }

    public long getLastAccessApplication() {
        return this.lastAccessApplication_;
    }

    public void setLastAccessApplication(long time) {
        this.lastAccessApplication_ = time;
    }

    @Override
    public String getUIComponentName() {
        return UIAPPLICATION;
    }

    @Override
    public <T extends UIComponent> T findComponentById(String lookupId) {
        if (this.getUIPopupMessages().getId().equals(lookupId)) {
            return (T)this.getUIPopupMessages();
        }
        return super.findComponentById(lookupId);
    }

    @Override
    public void renderChildren() throws Exception {
        super.renderChildren();
        if (this.getUIPopupMessages() == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.getUIPopupMessages().processRender(context);
    }

    @Override
    public void processAction(WebuiRequestContext context) throws Exception {
        try {
            super.processAction(context);
        }
        catch (MessageException ex) {
            this.addMessage(ex.getDetailMessage());
        }
        catch (Throwable t) {
            ApplicationMessage msg = new ApplicationMessage("UIApplication.msg.unknown-error", null, 0);
            this.addMessage(msg);
            log.error((Object)"Error during the processAction phase", t);
        }
    }

    public void renderBlockToUpdate(UIComponent uicomponent, WebuiRequestContext context, Writer w) throws Exception {
        w.write("<div class=\"BlockToUpdate\">");
        w.append("<div class=\"BlockToUpdateId\">").append(uicomponent.getId()).append("</div>");
        w.write("<div class=\"BlockToUpdateData\">");
        uicomponent.processRender(context);
        w.write("</div>");
        w.write("</div>");
    }
}

