/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public class UIFormSelectBox
extends UIFormStringInput {
    private boolean isMultiple_ = false;
    private int size_ = 1;
    private List<SelectItemOption<String>> options_;
    private String onchange_;

    public UIFormSelectBox() {
    }

    public UIFormSelectBox(String name, String bindingExpression, List<SelectItemOption<String>> options) {
        super(name, bindingExpression, (String)null);
        this.setOptions(options);
    }

    public boolean isMultiple() {
        return this.isMultiple_;
    }

    public final UIFormSelectBox setMultiple(boolean bl) {
        this.isMultiple_ = bl;
        return this;
    }

    public final UIFormSelectBox setSize(int i) {
        this.size_ = i;
        return this;
    }

    public UIFormSelectBox setValue(String value) {
        this.value_ = value;
        for (SelectItemOption<String> option : this.options_) {
            if (option.getValue().equals(this.value_)) {
                option.setSelected(true);
                continue;
            }
            option.setSelected(false);
        }
        return this;
    }

    public String[] getSelectedValues() {
        if (this.isMultiple_) {
            ArrayList<String> selectedValues = new ArrayList<String>();
            for (int i = 0; i < this.options_.size(); ++i) {
                SelectItemOption<String> item = this.options_.get(i);
                if (!item.isSelected()) continue;
                selectedValues.add(item.getValue());
            }
            return selectedValues.toArray(new String[0]);
        }
        return new String[]{(String)this.value_};
    }

    public UIFormSelectBox setSelectedValues(String[] values) {
        block0: for (SelectItemOption<String> option : this.options_) {
            option.setSelected(false);
            for (String value : values) {
                if (!value.equals(option.getValue())) continue;
                option.setSelected(true);
                continue block0;
            }
        }
        return this;
    }

    public final List<SelectItemOption<String>> getOptions() {
        return this.options_;
    }

    public final UIFormSelectBox setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        if (this.options_ == null || this.options_.size() < 1) {
            return this;
        }
        this.value_ = this.options_.get(0).getValue();
        return this;
    }

    @Override
    public void reset() {
        if (this.options_ == null || this.options_.size() < 1) {
            return;
        }
        this.value_ = this.options_.get(0).getValue();
        for (SelectItemOption<String> option : this.options_) {
            option.setSelected(false);
        }
        this.options_.get(0).setSelected(true);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public UIFormSelectBox setDisabled(boolean disabled) {
        return (UIFormSelectBox)super.setDisabled(disabled);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        String[] values = context.getRequestParameterValues(this.getId());
        if (values == null) {
            this.value_ = null;
            for (SelectItemOption<String> item : this.options_) {
                item.setSelected(false);
            }
            return;
        }
        int i = 0;
        this.value_ = values[0];
        for (SelectItemOption<String> item : this.options_) {
            if (i > -1 && item.getValue().equals(values[i])) {
                item.setSelected(true);
                if (values.length != ++i) continue;
                i = -1;
                continue;
            }
            item.setSelected(false);
        }
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, this.getId());
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String formId = null;
        formId = uiForm.getId().equals("UISearchForm") ? uiForm.getParent().getId() : uiForm.getId();
        Writer w = context.getWriter();
        w.write("<select class=\"selectbox\" name=\"");
        w.write(this.name);
        w.write("\"");
        w.write(" id=\"" + this.getId() + "\"");
        if (this.onchange_ != null) {
            w.append(" onchange=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isMultiple_) {
            w.write(" multiple=\"true\"");
        }
        if (this.size_ > 1) {
            w.write(" size=\"" + this.size_ + "\"");
        }
        if (this.isDisabled()) {
            w.write(" disabled ");
        }
        this.renderHTMLAttributes(w);
        w.write(">\n");
        for (SelectItemOption<String> item : this.options_) {
            String label = item.getLabel();
            try {
                label = res.getString(formId + ".label.option." + item.getValue());
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            String value = item.getValue();
            value = HTMLEntityEncoder.getInstance().encodeHTMLAttribute(value);
            if (item.isSelected()) {
                w.write("<option selected=\"selected\" value=\"");
                w.write(value);
                w.write("\">");
            } else {
                w.write("<option value=\"");
                w.write(item.getValue());
                w.write("\">");
            }
            w.write(label);
            w.write("</option>\n");
        }
        w.write("</select>\n");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

