/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.WebAppInitContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.configuration.MockConfigurationManagerImpl;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.monitor.jvm.OperatingSystemInfo;
import org.exoplatform.container.security.ContainerPermissions;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.test.mocks.servlet.MockServletContext;

@Managed
@NameTemplate(value={@Property(key="container", value="root")})
@RESTEndpoint(path="rcontainer")
public class RootContainer
extends ExoContainer {
    private static final long serialVersionUID = 812448359436635438L;
    private static volatile RootContainer singleton_;
    private OperatingSystemInfo osenv_;
    private PortalContainerConfig config_;
    private static final Log LOG;
    private static volatile boolean booting;
    private final J2EEServerInfo serverenv_ = new J2EEServerInfo();
    private final Set<String> profiles;
    private final ConcurrentMap<String, ConcurrentMap<String, Queue<PortalContainerInitTaskContext>>> initTasks = new ConcurrentHashMap<String, ConcurrentMap<String, Queue<PortalContainerInitTaskContext>>>();
    private final Queue<WebAppInitContext> portalContexts = new ConcurrentLinkedQueue<WebAppInitContext>();

    public RootContainer() {
        HashSet<String> profiles = new HashSet<String>();
        String envProfile = this.serverenv_.getServerName();
        if (envProfile != null) {
            profiles.add(envProfile);
        }
        profiles.addAll(ExoContainer.getProfiles());
        LOG.info((Object)("Active profiles " + profiles));
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(new ShutdownThread(RootContainer.this));
                return null;
            }
        });
        this.profiles = profiles;
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                RootContainer.this.registerComponentInstance(J2EEServerInfo.class, RootContainer.this.serverenv_);
                return null;
            }
        });
    }

    public OperatingSystemInfo getOSEnvironment() {
        if (this.osenv_ == null) {
            this.osenv_ = (OperatingSystemInfo)this.getComponentInstanceOfType(OperatingSystemInfo.class);
        }
        return this.osenv_;
    }

    PortalContainerConfig getPortalContainerConfig() {
        if (this.config_ == null) {
            this.config_ = (PortalContainerConfig)this.getComponentInstanceOfType(PortalContainerConfig.class);
        }
        return this.config_;
    }

    public boolean isPortalContainerConfigAware() {
        return this.getPortalContainerConfig().hasDefinition();
    }

    public J2EEServerInfo getServerEnvironment() {
        return this.serverenv_;
    }

    public PortalContainer getPortalContainer(final String name) {
        J2EEServerInfo senv;
        PortalContainer pcontainer = (PortalContainer)this.getComponentInstance(name);
        if (pcontainer == null && ("standalone".equals((senv = this.getServerEnvironment()).getServerName()) || "test".equals(senv.getServerName()))) {
            try {
                MockServletContext scontext = new MockServletContext(name);
                final PortalContainer currentPortalContainer = pcontainer = new PortalContainer(this, (ServletContext)scontext);
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        PortalContainer.setInstance(currentPortalContainer);
                        return null;
                    }
                });
                final MockConfigurationManagerImpl cService = new MockConfigurationManagerImpl((ServletContext)scontext);
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/test-configuration.xml"));
                cService.processRemoveConfiguration();
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        currentPortalContainer.registerComponentInstance(ConfigurationManager.class, cService);
                        RootContainer.this.registerComponentInstance(name, currentPortalContainer);
                        currentPortalContainer.start(true);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return pcontainer;
    }

    public void registerPortalContainer(ServletContext context) {
        PortalContainerConfig config;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if ((config = this.getPortalContainerConfig()).hasDefinition()) {
            if (config.isPortalContainerName(context.getServletContextName())) {
                this.portalContexts.add(new WebAppInitContext(context));
            } else {
                if (PropertyManager.isDevelopping()) {
                    LOG.info((Object)("We assume that the ServletContext '" + context.getServletContextName() + "' is not a portal since no portal container definition with the same name has been" + " registered to the component PortalContainerConfig. The related portal container" + " will be declared as disabled."));
                }
                config.disablePortalContainer(context.getServletContextName());
            }
            PortalContainerPreInitTask task = new PortalContainerPreInitTask(){

                public void execute(ServletContext context, PortalContainer portalContainer) {
                    portalContainer.registerContext(context);
                }
            };
            PortalContainer.addInitTask(context, task);
        } else {
            config.registerPortalContainerName(context.getServletContextName());
            this.createPortalContainer(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPortalContainers() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        try {
            WebAppInitContext context;
            while ((context = this.portalContexts.poll()) != null) {
                Thread.currentThread().setContextClassLoader(context.getWebappClassLoader());
                hasChanged = true;
                this.createPortalContainer(context.getServletContext());
            }
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        PortalContainerConfig config = this.getPortalContainerConfig();
        for (String portalContainerName : this.initTasks.keySet()) {
            if (!config.isPortalContainerName(portalContainerName)) continue;
            LOG.warn((Object)("The portal container '" + portalContainerName + "' doesn't not exist or" + " it has not yet been registered, please check your PortalContainerDefinitions and " + "the loading order."));
            config.unregisterPortalContainerName(portalContainerName);
        }
        this.initTasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPortalContainer(ServletContext context) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        String portalContainerName = context.getServletContextName();
        try {
            LOG.info((Object)("Trying to create the portal container '" + portalContainerName + "'"));
            PortalContainer pcontainer = new PortalContainer(this, context);
            PortalContainer.setInstance(pcontainer);
            this.executeInitTasks(pcontainer, "pre-init");
            Thread.currentThread().setContextClassLoader(pcontainer.getPortalClassLoader());
            hasChanged = true;
            ConfigurationManagerImpl cService = new ConfigurationManagerImpl(pcontainer.getPortalContext(), this.profiles);
            try {
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot add configuration conf/portal/configuration.xml. ServletContext: " + context), (Throwable)ex);
            }
            String uri = this.serverenv_.isJBoss() ? "conf/portal/jboss-configuration.xml" : "conf/portal/generic-configuration.xml";
            Collection<URL> envConf = ContainerUtil.getConfigurationURL(uri);
            try {
                cService.addConfiguration(envConf);
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot add configuration " + uri + ". ServletContext: " + context), (Throwable)ex);
            }
            Set<WebAppInitContext> contexts = pcontainer.getWebAppInitContexts();
            for (WebAppInitContext webappctx : contexts) {
                ServletContext ctx = webappctx.getServletContext();
                try {
                    cService.addConfiguration(ctx, "war:/conf/configuration.xml");
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot add configuration war:/conf/configuration.xml. ServletContext: " + ctx), (Throwable)ex);
                }
            }
            String overrideConfig = singleton_.getServerEnvironment().getExoConfigurationDirectory() + "/portal/" + portalContainerName + "/configuration.xml";
            try {
                File file = new File(overrideConfig);
                if (file.exists()) {
                    cService.addConfiguration(file.toURI().toURL());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot add configuration " + overrideConfig + ". ServletContext: " + context), (Throwable)ex);
            }
            cService.processRemoveConfiguration();
            pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
            this.registerComponentInstance(portalContainerName, pcontainer);
            pcontainer.start(true);
            this.getManagementContext().register(pcontainer);
            this.executeInitTasks(pcontainer, "post-init");
            this.executeInitTasks(pcontainer, "post-create");
            LOG.info((Object)("The portal container '" + portalContainerName + "' has been created successfully"));
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot create the portal container '" + portalContainerName + "' . ServletContext: " + context), (Throwable)ex);
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            try {
                PortalContainer.setInstance(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    public synchronized void removePortalContainer(ServletContext servletContext) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        this.unregisterComponent(servletContext.getServletContextName());
    }

    public static Object getComponent(Class key) {
        return RootContainer.getInstance().getComponentInstanceOfType(key);
    }

    private static RootContainer buildRootContainer() {
        try {
            String confDir;
            String overrideConf;
            File file;
            final RootContainer rootContainer = new RootContainer();
            final ConfigurationManagerImpl service = new ConfigurationManagerImpl(rootContainer.profiles);
            service.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
            if (PrivilegedSystemHelper.getProperty((String)"maven.exoplatform.dir") != null) {
                service.addConfiguration(ContainerUtil.getConfigurationURL("conf/test-configuration.xml"));
            }
            if (PrivilegedFileHelper.exists((File)(file = new File(overrideConf = (confDir = rootContainer.getServerEnvironment().getExoConfigurationDirectory()) + "/configuration.xml")))) {
                service.addConfiguration("file:" + overrideConf);
            }
            service.processRemoveConfiguration();
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    rootContainer.registerComponentInstance(ConfigurationManager.class, service);
                    rootContainer.start(true);
                    return null;
                }
            });
            return rootContainer;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not build root container", (Throwable)e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RootContainer getInstance() {
        RootContainer result = singleton_;
        if (result != null) return result;
        Class<RootContainer> clazz = RootContainer.class;
        synchronized (RootContainer.class) {
            result = singleton_;
            if (result != null) return result;
            if (booting) {
                throw new IllegalStateException("Already booting by the same thread");
            }
            booting = true;
            try {
                LOG.info((Object)"Building root container");
                long time = -System.currentTimeMillis();
                result = RootContainer.buildRootContainer();
                if (result != null) {
                    LOG.info((Object)("Root container is built (build time " + (time += System.currentTimeMillis()) + "ms)"));
                    singleton_ = result;
                    SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ExoContainerContext.setTopContainer(singleton_);
                            return null;
                        }
                    });
                    LOG.info((Object)"Root container booted");
                } else {
                    LOG.error((Object)"Failed to boot root container");
                }
            }
            finally {
                booting = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void setInstance(RootContainer rcontainer) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        singleton_ = rcontainer;
    }

    @Managed
    @ManagedDescription(value="The configuration of the container in XML format.")
    public String getConfigurationXML() {
        Configuration config = this.getConfiguration();
        if (config == null) {
            LOG.warn((Object)"The configuration of the RootContainer could not be found");
            return null;
        }
        return config.toXML();
    }

    public void addInitTask(ServletContext context, PortalContainerInitTask task) {
        this.addInitTask(context, task, context.getServletContextName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitTask(ServletContext context, PortalContainerInitTask task, String portalContainer) {
        PortalContainer container;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (!task.alreadyExists(container = this.getPortalContainer(portalContainer))) {
            List<String> dependencies;
            Queue q;
            String type;
            Queue<PortalContainerInitTaskContext> queue;
            ConcurrentMap q2;
            ConcurrentMap<String, ConcurrentLinkedQueue<PortalContainerInitTaskContext>> queues;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The portal container '" + portalContainer + "' has not yet been initialized, thus the task can be added"));
            }
            if ((queues = (ConcurrentHashMap)this.initTasks.get(portalContainer)) == null && (q2 = (ConcurrentMap)this.initTasks.putIfAbsent(portalContainer, queues = new ConcurrentHashMap())) != null) {
                queues = q2;
            }
            if ((queue = (ConcurrentLinkedQueue<PortalContainerInitTaskContext>)queues.get(type = task.getType())) == null && (q = (Queue)queues.putIfAbsent(type, (ConcurrentLinkedQueue<PortalContainerInitTaskContext>)(queue = (dependencies = this.getPortalContainerConfig().getDependencies(portalContainer)) == null || dependencies.isEmpty() ? new ConcurrentLinkedQueue<PortalContainerInitTaskContext>() : new PriorityBlockingQueue<PortalContainerInitTaskContext>(10, new PortalContainerInitTaskContextComparator(dependencies))))) != null) {
                queue = q;
            }
            queue.add(new PortalContainerInitTaskContext(context, task));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The portal container '" + portalContainer + "' has already been initialized, thus we call onAlreadyExists"));
            }
            PortalContainer oldPortalContainer = PortalContainer.getInstanceIfPresent();
            try {
                PortalContainer.setInstance(container);
                task.onAlreadyExists(context, container);
            }
            finally {
                PortalContainer.setInstance(oldPortalContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInitTasks(PortalContainer portalContainer, String type) {
        String portalContainerName = portalContainer.getName();
        ConcurrentMap queues = (ConcurrentMap)this.initTasks.get(portalContainerName);
        if (queues == null) {
            return;
        }
        Queue queue = (Queue)queues.get(type);
        if (queue == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start launching the " + type + " tasks of the portal container '" + portalContainer + "'"));
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        try {
            PortalContainerInitTaskContext context;
            while ((context = (PortalContainerInitTaskContext)queue.poll()) != null) {
                Thread.currentThread().setContextClassLoader(context.getWebappClassLoader());
                hasChanged = true;
                context.getTask().execute(context.getServletContext(), portalContainer);
            }
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        queues.remove(type);
        if (queues.isEmpty()) {
            this.initTasks.remove(portalContainerName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End launching the " + type + " tasks of the portal container '" + portalContainer + "'"));
        }
    }

    public void stop() {
        super.stop();
        ExoContainerContext.setTopContainer(null);
    }

    static {
        LOG = ExoLogger.getLogger((String)"exo.kernel.container.RootContainer");
        booting = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortalContainerInitTaskContextComparator
    implements Comparator<PortalContainerInitTaskContext> {
        private final List<String> dependencies;

        PortalContainerInitTaskContextComparator(List<String> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public int compare(PortalContainerInitTaskContext ctx1, PortalContainerInitTaskContext ctx2) {
            int idx1 = this.dependencies.indexOf(ctx1.getServletContextName());
            int idx2 = this.dependencies.indexOf(ctx2.getServletContextName());
            if (idx1 == -1 && idx2 != -1) {
                return 1;
            }
            if (idx1 != -1 && idx2 == -1) {
                return -1;
            }
            if (idx1 == -1 && idx2 == -1) {
                return ctx1.getServletContextName().compareTo(ctx2.getServletContextName());
            }
            return idx1 - idx2;
        }
    }

    static class PortalContainerInitTaskContext
    extends WebAppInitContext {
        private final PortalContainerInitTask task;

        PortalContainerInitTaskContext(ServletContext context, PortalContainerInitTask task) {
            super(context);
            this.task = task;
        }

        public PortalContainerInitTask getTask() {
            return this.task;
        }
    }

    public static abstract class PortalContainerPostCreateTask
    implements PortalContainerInitTask {
        public static final String TYPE = "post-create";

        public final boolean alreadyExists(PortalContainer portalContainer) {
            return portalContainer != null && portalContainer.isStarted();
        }

        public final void onAlreadyExists(ServletContext context, PortalContainer portalContainer) {
            this.execute(context, portalContainer);
        }

        public final String getType() {
            return TYPE;
        }
    }

    public static abstract class PortalContainerPreInitTask
    implements PortalContainerInitTask {
        public static final String TYPE = "pre-init";

        public final boolean alreadyExists(PortalContainer portalContainer) {
            return portalContainer != null;
        }

        public final void onAlreadyExists(ServletContext context, PortalContainer portalContainer) {
            throw new IllegalStateException("No pre init tasks can be added to the portal container '" + portalContainer.getName() + "', because it has already been " + "initialized. Check the webapp '" + context.getServletContextName() + "'");
        }

        public final String getType() {
            return TYPE;
        }
    }

    public static abstract class PortalContainerPostInitTask
    implements PortalContainerInitTask {
        public static final String TYPE = "post-init";

        public final boolean alreadyExists(PortalContainer portalContainer) {
            return portalContainer != null && portalContainer.isStarted();
        }

        public final void onAlreadyExists(ServletContext context, PortalContainer portalContainer) {
            this.execute(context, portalContainer);
        }

        public final String getType() {
            return TYPE;
        }
    }

    public static interface PortalContainerInitTask {
        public boolean alreadyExists(PortalContainer var1);

        public void onAlreadyExists(ServletContext var1, PortalContainer var2);

        public void execute(ServletContext var1, PortalContainer var2);

        public String getType();
    }

    static class ShutdownThread
    extends Thread {
        RootContainer container_;

        ShutdownThread(RootContainer container) {
            this.container_ = container;
        }

        public void run() {
            this.container_.stop();
        }
    }
}

