/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.dataobject.runtime;

import groovy.lang.GroovyClassLoader;
import java.util.Arrays;
import java.util.List;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.dataobject.runtime.DataObjectChromatticSession;
import org.chromattic.dataobject.runtime.DataObjectSessionLifeCycle;

public class ChromatticInjector {
    public static void contextualize(Object obj, Object injected) {
        if (obj instanceof DataObjectChromatticSession) {
            DataObjectChromatticSession session = (DataObjectChromatticSession)obj;
            if (session.builder == null) {
                Class<?> injectedType = injected.getClass();
                GroovyClassLoader.InnerLoader cl = (GroovyClassLoader.InnerLoader)injectedType.getClassLoader();
                List<Class> classes = Arrays.asList(cl.getLoadedClasses());
                try {
                    ChromatticBuilder builder = ChromatticBuilder.create();
                    for (Class clazz : classes) {
                        if (!clazz.isAnnotationPresent(PrimaryType.class) && !clazz.isAnnotationPresent(MixinType.class)) continue;
                        builder.add(clazz);
                    }
                    builder.setOptionValue(ChromatticBuilder.CREATE_ROOT_NODE, (Object)true);
                    builder.setOptionValue(ChromatticBuilder.LAZY_CREATE_ROOT_NODE, (Object)true);
                    builder.setOptionValue(ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME, (Object)DataObjectSessionLifeCycle.class.getName());
                    builder.init();
                    session.builder = builder;
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }
}

