/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ManageDrivePlugin
extends BaseComponentPlugin {
    private static String WORKSPACE = "exo:workspace";
    private static String PERMISSIONS = "exo:accessPermissions";
    private static String VIEWS = "exo:views";
    private static String ICON = "exo:icon";
    private static String PATH = "exo:path";
    private static String VIEW_REFERENCES = "exo:viewPreferences";
    private static String VIEW_NON_DOCUMENT = "exo:viewNonDocument";
    private static String VIEW_SIDEBAR = "exo:viewSideBar";
    private static String SHOW_HIDDEN_NODE = "exo:showHiddenNode";
    private static String ALLOW_CREATE_FOLDER = "exo:allowCreateFolders";
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private InitParams params_;
    private DMSConfiguration dmsConfiguration_;
    private static final Log LOG = ExoLogger.getLogger((String)ManageDrivePlugin.class.getName());

    public ManageDrivePlugin(RepositoryService repositoryService, InitParams params, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.params_ = params;
        this.dmsConfiguration_ = dmsConfiguration;
    }

    public void init() throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        while (it.hasNext()) {
            DriveData data = (DriveData)((ObjectParameter)it.next()).getObject();
            try {
                Session session = this.getSession();
                this.addDrive(data, session);
                session.logout();
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)(" ==> Can not init drive '" + data.getName() + "' in repository '" + this.repositoryService_.getCurrentRepository().getConfiguration().getName() + "'"));
            }
        }
    }

    public void init(String repository) throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        DriveData data = null;
        Session session = null;
        while (it.hasNext()) {
            data = (DriveData)((ObjectParameter)it.next()).getObject();
            try {
                session = this.getSession();
                this.addDrive(data, session);
                session.logout();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)e.getMessage());
            }
        }
    }

    private void addDrive(DriveData data, Session session) throws Exception {
        String drivesPath = this.nodeHierarchyCreator_.getJcrPath("exoDrivesPath");
        Node driveHome = (Node)session.getItem(drivesPath);
        Node driveNode = null;
        if (!driveHome.hasNode(data.getName())) {
            driveNode = driveHome.addNode(data.getName(), "exo:drive");
            driveNode.setProperty(WORKSPACE, data.getWorkspace());
            driveNode.setProperty(PERMISSIONS, data.getPermissions());
            driveNode.setProperty(PATH, data.getHomePath());
            driveNode.setProperty(VIEWS, data.getViews());
            driveNode.setProperty(ICON, data.getIcon());
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(data.getViewPreferences()));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(data.getViewNonDocument()));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(data.getViewSideBar()));
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(data.getShowHiddenNode()));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, data.getAllowCreateFolders());
            driveHome.save();
            session.save();
        }
    }

    private Session getSession() throws Exception {
        ManageableRepository manaRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return manaRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
    }
}

