/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.security.CryptFilter;
import org.icepdf.core.util.Library;

public class EncryptionDictionary
extends Dictionary {
    private Vector fileID = null;
    private CryptFilter cryptFilter;
    private boolean isAuthenticatedUserPassword;
    private boolean isAuthenticatedOwnerPassword;

    public EncryptionDictionary(Library lib, Hashtable encryptionDictionary, Vector fileID) {
        super(lib, encryptionDictionary);
        this.entries = encryptionDictionary;
        this.fileID = fileID;
    }

    public Vector getFileID() {
        return this.fileID;
    }

    public String getPreferredSecurityHandlerName() {
        return this.library.getName(this.entries, "Filter");
    }

    public String getPreferredSecurityHandlerSubName() {
        return this.library.getName(this.entries, "SubFilter");
    }

    public int getVersion() {
        return this.library.getInt(this.entries, "V");
    }

    public int getKeyLength() {
        int length = 40;
        int len = this.library.getInt(this.entries, "Length");
        if (len != 0) {
            length = len;
        }
        return length;
    }

    public int getRevisionNumber() {
        return this.library.getInt(this.entries, "R");
    }

    public String getBigO() {
        Object tmp = this.library.getObject(this.entries, "O");
        if (tmp instanceof StringObject) {
            return ((StringObject)tmp).getLiteralString();
        }
        return null;
    }

    public String getBigU() {
        Object tmp = this.library.getObject(this.entries, "U");
        if (tmp instanceof StringObject) {
            return ((StringObject)this.library.getObject(this.entries, "U")).getLiteralString();
        }
        return null;
    }

    public int getPermissions() {
        return this.library.getInt(this.entries, "P");
    }

    public CryptFilter getCryptFilter() {
        Hashtable tmp;
        if (this.cryptFilter == null && (tmp = (Hashtable)this.library.getObject(this.entries, "CF")) != null) {
            this.cryptFilter = new CryptFilter(this.library, tmp);
            return this.cryptFilter;
        }
        return this.cryptFilter;
    }

    public Name getStmF() {
        Object tmp = this.library.getObject(this.entries, "StmF");
        if (tmp != null && tmp instanceof Name) {
            return (Name)tmp;
        }
        return null;
    }

    public Name getStrF() {
        Object tmp = this.library.getObject(this.entries, "StrF");
        if (tmp != null && tmp instanceof Name) {
            return (Name)tmp;
        }
        return null;
    }

    public Name getEEF() {
        Object tmp = this.library.getObject(this.entries, "EEF");
        if (tmp != null && tmp instanceof Name) {
            return (Name)tmp;
        }
        return null;
    }

    public String getBigOE() {
        Object tmp = this.library.getObject(this.entries, "OE");
        if (tmp instanceof StringObject) {
            return ((StringObject)this.library.getObject(this.entries, "OE")).getLiteralString();
        }
        return null;
    }

    public String getBigUE() {
        Object tmp = this.library.getObject(this.entries, "UE");
        if (tmp instanceof StringObject) {
            return ((StringObject)this.library.getObject(this.entries, "UE")).getLiteralString();
        }
        return null;
    }

    public String getPerms() {
        Object tmp = this.library.getObject(this.entries, "Perms");
        if (tmp instanceof StringObject) {
            return ((StringObject)this.library.getObject(this.entries, "Perms")).getLiteralString();
        }
        return null;
    }

    public boolean isEncryptMetaData() {
        return this.library.getBoolean(this.entries, "EncryptMetadata");
    }

    protected boolean isAuthenticatedUserPassword() {
        return this.isAuthenticatedUserPassword;
    }

    protected void setAuthenticatedUserPassword(boolean authenticatedUserPassword) {
        this.isAuthenticatedUserPassword = authenticatedUserPassword;
    }

    protected boolean isAuthenticatedOwnerPassword() {
        return this.isAuthenticatedOwnerPassword;
    }

    protected void setAuthenticatedOwnerPassword(boolean authenticatedOwnerPassword) {
        this.isAuthenticatedOwnerPassword = authenticatedOwnerPassword;
    }

    public Object getValue(Object key) {
        return this.entries.get(key);
    }

    public Hashtable getEntries() {
        return this.entries;
    }

    public String toString() {
        return "Encryption Dictionary:  \n  fileID: " + this.getFileID() + " \n" + "  Filter: " + this.getPreferredSecurityHandlerName() + " \n" + "  SubFilter: " + this.getPreferredSecurityHandlerSubName() + " \n" + "  V: " + this.getVersion() + " \n" + "  P: " + this.getPermissions() + " \n" + "  Length:" + this.getKeyLength() + " \n" + "  CF: " + this.cryptFilter + " \n" + "  StmF: " + this.getStmF() + " \n" + "  StrF: " + this.getStrF() + " \n" + "  R: " + this.getRevisionNumber() + " \n" + "  O: " + this.getBigO() + " \n" + "  U: " + this.getBigU() + " \n" + " UE: " + this.getBigUE() + " \n" + " OE: " + this.getBigOE() + " \n" + "  Recipients: " + "not done yet" + " \n" + "  ";
    }
}

