/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.io.IOUtils;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.gadget.core.ExoDefaultSecurityTokenGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/wcmGadget/")
public class GadgetConnector
extends ExoDefaultSecurityTokenGenerator
implements ResourceContainer {
    public static final String FCK_RESOURCE_BUNDLE_FILE = "locale.services.fckeditor.FCKConnector";
    private ApplicationRegistryService applicationRegistryService = (ApplicationRegistryService)WCMCoreUtils.getService(ApplicationRegistryService.class);
    private GadgetRegistryService gadgetRegistryService = (GadgetRegistryService)WCMCoreUtils.getService(GadgetRegistryService.class);
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Log LOG = ExoLogger.getLogger((String)GadgetConnector.class.getName());

    public GadgetConnector(InitParams initParams) throws Exception {
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="lang") String language, @QueryParam(value="host") String host) throws Exception {
        block3: {
            try {
                Response response = this.buildXMLResponse(currentFolder, language, host);
                if (response != null) {
                    return response;
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Error when perform getFoldersAndFiles: ", (Throwable)e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response buildXMLResponse(String currentFolder, String language, String host) throws Exception {
        List<ApplicationCategory> applicationCategories = this.getGadgetCategories();
        Element rootElement = this.createRootElement(currentFolder, applicationCategories, language, host);
        Document document = rootElement.getOwnerDocument();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element createRootElement(String currentFolder, List<ApplicationCategory> applicationCategories, String language, String host) throws Exception {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        if (applicationCategories.isEmpty()) {
            Locale locale = null;
            locale = language == null ? Locale.ENGLISH : new Locale(language);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(FCK_RESOURCE_BUNDLE_FILE, locale);
            String message = "";
            try {
                message = resourceBundle.getString("fckeditor.no-gadget");
            }
            catch (MissingResourceException e) {
                message = "fckeditor.no-gadget";
            }
            Element rootElement = document.createElement("Message");
            document.appendChild(rootElement);
            rootElement.setAttribute("number", "555");
            rootElement.setAttribute("text", message);
            rootElement.setAttribute("type", "Error");
            return rootElement;
        }
        Element rootElement = document.createElement("Connector");
        document.appendChild(rootElement);
        rootElement.setAttribute("resourceType", "Gadget");
        Element currentFolderElement = document.createElement("CurrentFolder");
        if (currentFolder == null || currentFolder.equals("/")) {
            currentFolderElement.setAttribute("name", applicationCategories.get(0).getName());
            Element foldersElement = this.createFolderElement(document, applicationCategories);
            rootElement.appendChild(foldersElement);
        } else {
            PortalContainer container = PortalContainer.getInstance();
            RequestLifeCycle.begin((ExoContainer)container);
            try {
                ApplicationCategory applicationCategory = this.applicationRegistryService.getApplicationCategory(currentFolder.substring(1, currentFolder.length() - 1));
                currentFolderElement.setAttribute("name", applicationCategory.getDisplayName());
                Element filesElement = this.createFileElement(document, applicationCategory, host);
                rootElement.appendChild(filesElement);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        rootElement.appendChild(currentFolderElement);
        return rootElement;
    }

    private Element createFolderElement(Document document, List<ApplicationCategory> applicationCategories) throws Exception {
        Element folders = document.createElement("Folders");
        for (ApplicationCategory applicationCategory : applicationCategories) {
            Element folder = document.createElement("Folder");
            folder.setAttribute("name", applicationCategory.getDisplayName());
            folders.appendChild(folder);
        }
        return folders;
    }

    private Element createFileElement(Document document, ApplicationCategory applicationCategory, String host) throws Exception {
        Element files = document.createElement("Files");
        List listApplication = this.applicationRegistryService.getApplications(applicationCategory, new ApplicationType[]{ApplicationType.GADGET});
        for (Application application : listApplication) {
            Gadget gadget = this.gadgetRegistryService.getGadget(application.getApplicationName());
            Element file = document.createElement("File");
            file.setAttribute("name", gadget.getName());
            file.setAttribute("fileType", "nt_unstructured");
            file.setAttribute("size", "0");
            file.setAttribute("thumbnail", gadget.getThumbnail());
            file.setAttribute("description", gadget.getDescription());
            String fullurl = "";
            fullurl = gadget.isLocal() ? "/" + PortalContainer.getCurrentRestContextName() + "/" + gadget.getUrl() : gadget.getUrl();
            file.setAttribute("url", fullurl);
            String data = "{\"context\":{\"country\":\"US\",\"language\":\"en\"},\"gadgets\":[{\"moduleId\":0,\"url\":\"" + fullurl + "\",\"prefs\":[]}]}";
            URL url = new URL(host + "/eXoGadgetServer/gadgets/metadata");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            String strMetadata = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            wr.close();
            JSONObject metadata = new JSONObject(strMetadata.toString());
            ConversationState conversationState = ConversationState.getCurrent();
            String userId = conversationState.getIdentity().getUserId();
            String token = this.createToken(gadget.getUrl(), userId, userId, new Random().nextLong(), "default");
            JSONObject obj = metadata.getJSONArray("gadgets").getJSONObject(0);
            obj.put("secureToken", (Object)token);
            file.setAttribute("metadata", metadata.toString());
            files.appendChild(file);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApplicationCategory> getGadgetCategories() throws Exception {
        ArrayList<ApplicationCategory> gadgetCategories = new ArrayList<ApplicationCategory>();
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            List applicationCategories = this.applicationRegistryService.getApplicationCategories();
            for (ApplicationCategory applicationCategory : applicationCategories) {
                if (this.applicationRegistryService.getApplications(applicationCategory, new ApplicationType[]{ApplicationType.GADGET}).isEmpty()) continue;
                gadgetCategories.add(applicationCategory);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        return gadgetCategories;
    }
}

