/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gatein.mop.core.util.Tools;
import org.gatein.mop.spi.AdapterLifeCycle;

class AdapterRegistration<T, A> {
    private static final Map<Class<?>, AdapterRegistration<?, ?>> instances;
    final AdapterLifeCycle<T, A> factory;
    final Class<T> adapteeType;
    final Class<A> adapterType;

    static <A> AdapterRegistration<Object, A> getInstance(Class<A> type) {
        return instances.get(type);
    }

    AdapterRegistration(AdapterLifeCycle<T, A> factory) {
        this.factory = factory;
        this.adapteeType = (Class)Tools.resolve(factory.getClass(), AdapterLifeCycle.class, 0);
        this.adapterType = (Class)Tools.resolve(factory.getClass(), AdapterLifeCycle.class, 1);
    }

    static {
        ServiceLoader<AdapterLifeCycle> loader = ServiceLoader.load(AdapterLifeCycle.class);
        HashMap map = new HashMap();
        for (AdapterLifeCycle factory : loader) {
            AdapterRegistration registration = new AdapterRegistration(factory);
            map.put(registration.adapterType, registration);
        }
        instances = map;
    }
}

