/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import javax.ws.rs.core.EntityTag;
import org.exoplatform.services.rest.header.AbstractHeaderDelegate;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTagHeaderDelegate
extends AbstractHeaderDelegate<EntityTag> {
    @Override
    public Class<EntityTag> support() {
        return EntityTag.class;
    }

    public EntityTag fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        boolean isWeak = header.startsWith("W/");
        String value = isWeak ? header.substring(2) : header;
        value = value.substring(1, value.length() - 1);
        value = HeaderHelper.filterEscape(value);
        return new EntityTag(value, isWeak);
    }

    public String toString(EntityTag entityTag) {
        StringBuffer sb = new StringBuffer();
        if (entityTag.isWeak()) {
            sb.append('W').append('/');
        }
        sb.append('\"');
        HeaderHelper.appendEscapeQuote(sb, entityTag.getValue());
        sb.append('\"');
        return sb.toString();
    }
}

