/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.ConstructorDescriptor;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.ObjectModel;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.provider.ProviderDescriptor;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

public class ResourceDescriptorValidator
implements ResourceDescriptorVisitor {
    private static AtomicReference<ResourceDescriptorValidator> instance = new AtomicReference();

    public static ResourceDescriptorValidator getInstance() {
        ResourceDescriptorValidator t = instance.get();
        if (t == null) {
            instance.compareAndSet(null, new ResourceDescriptorValidator());
            t = instance.get();
        }
        return t;
    }

    public void visitAbstractResourceDescriptor(AbstractResourceDescriptor ard) {
        if (ard.isRootResource() && ard.getPathValue().getPath().length() == 0) {
            String msg = "Resource class " + ard.getObjectClass() + " is root resource but path value empty, see javax.ws.rs.Path#value()";
            throw new RuntimeException(msg);
        }
        this.checkObjectModel(ard);
        int resMethodCount = ard.getResourceMethods().size() + ard.getSubResourceMethods().size() + ard.getSubResourceLocators().size();
        if (resMethodCount == 0) {
            String msg = "Not found any resource methods, sub-resource methods or sub-resource locators in " + ard.getObjectClass().getName();
            throw new RuntimeException(msg);
        }
        for (List l : ard.getResourceMethods().values()) {
            for (ResourceMethodDescriptor rmd : l) {
                rmd.accept(this);
            }
        }
        for (ResourceMethodMap rmm : ard.getSubResourceMethods().values()) {
            for (List l : rmm.values()) {
                for (SubResourceMethodDescriptor rmd : l) {
                    rmd.accept(this);
                }
            }
        }
        for (SubResourceLocatorDescriptor loc : ard.getSubResourceLocators().values()) {
            loc.accept(this);
        }
    }

    public void visitResourceMethodDescriptor(ResourceMethodDescriptor rmd) {
        ResourceDescriptorValidator.checkMethodParameters(rmd);
    }

    public void visitSubResourceLocatorDescriptor(SubResourceLocatorDescriptor srld) {
        if (srld.getPathValue().getPath().length() == 0) {
            String msg = "Path value is empty for method " + srld.getMethod().getName() + " in resource class " + srld.getParentResource().getObjectClass() + ", see javax.ws.rs.Path#value()";
            throw new RuntimeException(msg);
        }
        ResourceDescriptorValidator.checkMethodParameters(srld);
    }

    public void visitSubResourceMethodDescriptor(SubResourceMethodDescriptor srmd) {
        if (srmd.getPathValue().getPath().length() == 0) {
            String msg = "Path value is null or empty for method " + srmd.getMethod().getName() + " in resource class " + srmd.getParentResource().getObjectClass() + ", see javax.ws.rs.Path#value()";
            throw new RuntimeException(msg);
        }
        ResourceDescriptorValidator.checkMethodParameters(srmd);
    }

    private static void checkMethodParameters(ResourceMethodDescriptor rmd) {
        List<MethodParameter> l = rmd.getMethodParameters();
        boolean entity = false;
        boolean form = false;
        for (int i = 0; i < l.size(); ++i) {
            MethodParameter mp = l.get(i);
            if (mp.getAnnotation() == null) {
                if (!entity) {
                    entity = true;
                    if (!form) continue;
                    ResourceDescriptorValidator.checkFormParam(mp.getParameterClass(), mp.getGenericType());
                    continue;
                }
                String msg = "Wrong or absent annotation at parameter with index " + i + " at " + rmd.getParentResource().getObjectClass() + "#" + rmd.getMethod().getName();
                throw new RuntimeException(msg);
            }
            if (mp.getAnnotation().annotationType() != FormParam.class) continue;
            form = true;
            if (!entity) continue;
            ResourceDescriptorValidator.checkFormParam(mp.getParameterClass(), mp.getGenericType());
        }
    }

    private static void checkMethodParameters(SubResourceLocatorDescriptor srld) {
        List<MethodParameter> l = srld.getMethodParameters();
        for (int i = 0; i < l.size(); ++i) {
            MethodParameter mp = l.get(i);
            if (mp.getAnnotation() != null) continue;
            String msg = "Wrong or absent annotation at parameter with index " + i + " at " + srld.getParentResource().getObjectClass() + "#" + srld.getMethod().getName();
            throw new RuntimeException(msg);
        }
    }

    private static void checkFormParam(Class clazz, Type type) {
        if (MultivaluedMap.class != clazz || !ResourceDescriptorValidator.checkGenericType(type)) {
            String msg = "If a any method parameter is annotated with FormParam then type of entity parameter MUST be MultivalueMap<String, String> or FormEntity";
            throw new RuntimeException(msg);
        }
    }

    private static boolean checkGenericType(Type type) {
        ParameterizedType pt;
        Type[] genericTypes;
        if (type instanceof ParameterizedType && (genericTypes = (pt = (ParameterizedType)type).getActualTypeArguments()).length == 2) {
            try {
                return String.class == (Class)genericTypes[0] && String.class == (Class)genericTypes[1];
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public void visitConstructorInjector(ConstructorDescriptor ci) {
    }

    public void visitFieldInjector(FieldInjector fi) {
    }

    public void visitFilterDescriptor(FilterDescriptor fd) {
        this.checkObjectModel(fd);
    }

    public void visitProviderDescriptor(ProviderDescriptor pd) {
        this.checkObjectModel(pd);
    }

    protected void checkObjectModel(ObjectModel model) {
        for (ConstructorDescriptor c : model.getConstructorDescriptors()) {
            c.accept(this);
        }
        for (FieldInjector f : model.getFieldInjectors()) {
            f.accept(this);
        }
    }
}

