/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.core.AbstractTypeInfo;
import org.reflext.core.TypeResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArrayTypeInfo<T, M, A, P, F>
extends AbstractTypeInfo<T, M, A, P, F>
implements ArrayTypeInfo {
    public AbstractArrayTypeInfo(TypeResolverImpl<T, M, A, P, F> domain) {
        super(domain);
    }

    public String getName() {
        TypeInfo componentType = this.getComponentType();
        if (componentType instanceof SimpleTypeInfo) {
            switch (((SimpleTypeInfo)componentType).getLiteralType()) {
                case BOOLEAN: {
                    return "[B";
                }
                case BYTE: {
                    return "[Z";
                }
                case DOUBLE: {
                    return "[D";
                }
                case INT: {
                    return "[I";
                }
                case FLOAT: {
                    return "[F";
                }
                case LONG: {
                    return "[J";
                }
                case SHORT: {
                    return "[S";
                }
            }
            throw new AssertionError();
        }
        return "[L" + componentType.getName() + ";";
    }

    public boolean isReified() {
        return this.getComponentType().isReified();
    }

    @Override
    public final int hashCode() {
        return 1 + this.getComponentType().hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayTypeInfo) {
            ArrayTypeInfo that = (ArrayTypeInfo)obj;
            return this.getComponentType().equals(that.getComponentType());
        }
        return false;
    }
}

