/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.aspects;

import java.io.Serializable;
import java.util.Map;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.RevalidateMarkupResponse;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.aspects.cache.ContentRef;
import org.gatein.pc.portlet.aspects.cache.StrongContentRef;

public class ConsumerCacheInterceptor
extends PortletInvokerInterceptor {
    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        String scopeKey = "cached_markup." + invocation.getWindowContext().getId();
        UserContext userContext = invocation.getUserContext();
        if (invocation instanceof RenderInvocation) {
            RenderInvocation renderInvocation = (RenderInvocation)invocation;
            StateString navigationalState = renderInvocation.getNavigationalState();
            Map publicNavigationalState = renderInvocation.getPublicNavigationalState();
            WindowState windowState = renderInvocation.getWindowState();
            Mode mode = renderInvocation.getMode();
            CacheEntry cachedEntry = (CacheEntry)userContext.getAttribute(scopeKey);
            if (cachedEntry != null) {
                boolean useEntry = false;
                StateString entryNavigationalState = cachedEntry.navigationalState;
                Map entryPublicNavigationalState = cachedEntry.publicNavigationalState;
                if (navigationalState == null) {
                    if (entryNavigationalState == null) {
                        useEntry = true;
                    } else if (entryNavigationalState instanceof ParametersStateString) {
                        useEntry = ((ParametersStateString)entryNavigationalState).getSize() == 0;
                    }
                } else if (entryNavigationalState == null) {
                    if (navigationalState instanceof ParametersStateString) {
                        useEntry = ((ParametersStateString)navigationalState).getSize() == 0;
                    }
                } else {
                    useEntry = navigationalState.equals(entryNavigationalState);
                }
                if (useEntry) {
                    if (publicNavigationalState == null) {
                        if (entryPublicNavigationalState != null) {
                            useEntry = entryPublicNavigationalState.size() == 0;
                        }
                    } else if (entryPublicNavigationalState == null) {
                        useEntry = publicNavigationalState.size() == 0;
                    } else {
                        ParameterMap publicPM = ParameterMap.wrap((Map)publicNavigationalState);
                        ParameterMap entryPM = ParameterMap.wrap((Map)entryPublicNavigationalState);
                        useEntry = publicPM.equals((Object)entryPM);
                    }
                }
                useEntry &= windowState.equals((Object)cachedEntry.windowState);
                if (!(useEntry &= mode.equals((Object)cachedEntry.mode))) {
                    cachedEntry = null;
                    userContext.setAttribute(scopeKey, null);
                }
            }
            ContentResponse cachedContent = cachedEntry != null ? cachedEntry.contentRef.getContent() : null;
            long now = System.currentTimeMillis();
            if (cachedContent == null || cachedEntry.expirationTimeMillis < now) {
                ContentResponse contentResponse;
                CacheControl control;
                Object response;
                if (cachedContent != null) {
                    renderInvocation.setValidationToken(cachedEntry.validationToken);
                }
                if ((response = super.invoke(invocation)) instanceof RevalidateMarkupResponse && cachedContent != null) {
                    RevalidateMarkupResponse revalidate = (RevalidateMarkupResponse)response;
                    control = revalidate.getCacheControl();
                    response = cachedContent instanceof FragmentResponse ? new FragmentResponse((FragmentResponse)cachedContent, control) : new ContentResponse(cachedContent, control);
                }
                if (response instanceof ContentResponse && (control = (contentResponse = (ContentResponse)response).getCacheControl()) != null) {
                    long expirationTimeMillis = 0L;
                    if (control.getExpirationSecs() == -1) {
                        expirationTimeMillis = Long.MAX_VALUE;
                    } else if (control.getExpirationSecs() > 0) {
                        expirationTimeMillis = System.currentTimeMillis() + (long)(control.getExpirationSecs() * 1000);
                    }
                    if (expirationTimeMillis > 0L) {
                        String validationToken = null;
                        if (control.getValidationToken() != null) {
                            validationToken = control.getValidationToken();
                        } else if (cachedEntry != null) {
                            validationToken = cachedEntry.validationToken;
                        }
                        CacheEntry cacheEntry = new CacheEntry(navigationalState, publicNavigationalState, windowState, mode, contentResponse, expirationTimeMillis, validationToken);
                        userContext.setAttribute(scopeKey, (Object)cacheEntry);
                    }
                }
                return response;
            }
            return cachedContent;
        }
        userContext.setAttribute(scopeKey, null);
        return super.invoke(invocation);
    }

    private static class CacheEntry
    implements Serializable {
        private final StateString navigationalState;
        private final WindowState windowState;
        private final Mode mode;
        private final Map<String, String[]> publicNavigationalState;
        private final ContentRef contentRef;
        private final long expirationTimeMillis;
        private final String validationToken;

        public CacheEntry(StateString navigationalState, Map<String, String[]> publicNavigationalState, WindowState windowState, Mode mode, ContentResponse content, long expirationTimeMillis, String validationToken) {
            if (expirationTimeMillis <= 0L) {
                throw new IllegalArgumentException();
            }
            this.navigationalState = navigationalState;
            this.windowState = windowState;
            this.mode = mode;
            this.publicNavigationalState = publicNavigationalState;
            this.contentRef = new StrongContentRef(content);
            this.expirationTimeMillis = expirationTimeMillis;
            this.validationToken = validationToken;
        }
    }
}

