/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.portlet.filter.PortletRequestWrapper;
import javax.portlet.filter.PortletResponseWrapper;

public class PortletUtils {
    public static final String PREFIX = "jbpns";
    public static final String SUFFIX = "snpbj";
    private static final String SLASH = "/";

    public static WindowState decodeWindowState(String windowStateName) {
        if (WindowState.NORMAL.toString().equalsIgnoreCase(windowStateName)) {
            return WindowState.NORMAL;
        }
        if (WindowState.MINIMIZED.toString().equalsIgnoreCase(windowStateName)) {
            return WindowState.MINIMIZED;
        }
        if (WindowState.MAXIMIZED.toString().equalsIgnoreCase(windowStateName)) {
            return WindowState.MAXIMIZED;
        }
        return new WindowState(windowStateName);
    }

    public static PortletMode decodePortletMode(String portletModeName) {
        if (PortletMode.EDIT.toString().equalsIgnoreCase(portletModeName)) {
            return PortletMode.EDIT;
        }
        if (PortletMode.HELP.toString().equalsIgnoreCase(portletModeName)) {
            return PortletMode.HELP;
        }
        if (PortletMode.VIEW.toString().equalsIgnoreCase(portletModeName)) {
            return PortletMode.VIEW;
        }
        return new PortletMode(portletModeName);
    }

    public static String generateNamespaceFrom(String windowId) {
        int length = windowId.length();
        StringBuffer tmp = new StringBuffer(length + 10);
        tmp.append('G');
        for (int i = windowId.lastIndexOf(SLASH) + 1; i < length; ++i) {
            char c = windowId.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '$') {
                tmp.append(c);
                continue;
            }
            tmp.append('_');
            tmp.append(Character.forDigit((c & 0xF0) >> 4, 16));
            tmp.append(Character.forDigit(c & 0xF, 16));
        }
        return tmp.toString();
    }

    public static <U extends PortletRequest> U unwrap(PortletRequest wrapped, Class<U> unwrapped) {
        while (wrapped instanceof PortletRequestWrapper) {
            PortletRequestWrapper wrapper = (PortletRequestWrapper)wrapped;
            wrapped = wrapper.getRequest();
        }
        if (unwrapped.isInstance(wrapped)) {
            return (U)((PortletRequest)unwrapped.cast(wrapped));
        }
        throw new IllegalArgumentException();
    }

    public static <U extends PortletResponse> U unwrap(PortletResponse wrapped, Class<U> unwrapped) {
        while (wrapped instanceof PortletResponseWrapper) {
            PortletResponseWrapper wrapper = (PortletResponseWrapper)wrapped;
            wrapped = wrapper.getResponse();
        }
        if (unwrapped.isInstance(wrapped)) {
            return (U)((PortletResponse)unwrapped.cast(wrapped));
        }
        throw new IllegalArgumentException();
    }
}

