/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.PortletURL;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.portlet.impl.jsr168.PortletParameterMap;
import org.gatein.pc.portlet.impl.jsr168.api.BaseURLImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;

public class PortletURLImpl
extends BaseURLImpl
implements javax.portlet.PortletURL {
    private final InternalPortletURL url;

    public static PortletURLImpl createActionURL(PortletInvocation invocation, PortletRequestImpl preq) {
        InternalActionURL url = new InternalActionURL(invocation.getNavigationalState());
        return new PortletURLImpl(invocation, preq, url, true);
    }

    public static PortletURLImpl createRenderURL(PortletInvocation invocation, PortletRequestImpl preq) {
        InternalRenderURL url = new InternalRenderURL(new PortletParameterMap(preq.navigationInfo));
        return new PortletURLImpl(invocation, preq, url, true);
    }

    private PortletURLImpl(PortletInvocation invocation, PortletRequestImpl preq, InternalPortletURL url, boolean filterable) {
        super(invocation, preq, filterable);
        this.url = url;
    }

    public PortletURLImpl(PortletURLImpl original) {
        super(original);
        this.url = original.url instanceof InternalRenderURL ? new InternalRenderURL((InternalRenderURL)original.url) : new InternalActionURL((InternalActionURL)original.url);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!this.preq.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Not supported", windowState);
        }
        this.url.windowState = windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (portletMode == null) {
            this.url.portletMode = null;
        } else {
            if (!this.preq.isPortletModeAllowed(portletMode)) {
                throw new PortletModeException("Not supported", portletMode);
            }
            this.url.portletMode = portletMode;
        }
    }

    public PortletMode getPortletMode() {
        return this.url.portletMode;
    }

    public WindowState getWindowState() {
        return this.url.windowState;
    }

    public void removePublicRenderParameter(String name) {
        this.url.removePublicRenderParameter(name);
    }

    @Override
    protected BaseURLImpl.InternalContainerURL getContainerURL() {
        return this.url;
    }

    @Override
    protected BaseURLImpl createClone() {
        return new PortletURLImpl(this);
    }

    @Override
    protected void filter(PortletURLGenerationListener listener) {
        if (this.url instanceof InternalActionURL) {
            listener.filterActionURL((javax.portlet.PortletURL)this);
        } else {
            listener.filterRenderURL((javax.portlet.PortletURL)this);
        }
    }

    private static class InternalRenderURL
    extends InternalPortletURL
    implements RenderURL {
        private final PortletParameterMap parameters;

        private InternalRenderURL(PortletParameterMap parameters) {
            this.parameters = parameters;
        }

        private InternalRenderURL(InternalRenderURL original) {
            super(original);
            this.parameters = new PortletParameterMap(original.parameters);
        }

        public StateString getNavigationalState() {
            return ParametersStateString.create(this.parameters.getPrivateMapSnapshot());
        }

        public Map<String, String[]> getPublicNavigationalStateChanges() {
            return this.parameters.getPublicMapSnapshot();
        }

        @Override
        protected void setParameter(String name, String value) {
            this.parameters.setParameterValue(name, value);
        }

        @Override
        protected void setParameter(String name, String[] values) {
            this.parameters.setParameterValues(name, values);
        }

        @Override
        protected void setParameters(Map<String, String[]> parameterMap) {
            this.parameters.setMap(parameterMap);
        }

        @Override
        protected void removePublicRenderParameter(String name) {
            this.parameters.removePublicParameterValue(name);
        }

        @Override
        protected Map<String, String[]> getParameters() {
            return this.parameters.getMap();
        }
    }

    private static class InternalActionURL
    extends InternalPortletURL
    implements ActionURL {
        private final ParametersStateString interactionState;
        private final StateString navigationalState;

        private InternalActionURL(StateString navigationalState) {
            this.interactionState = ParametersStateString.create();
            this.navigationalState = navigationalState;
        }

        private InternalActionURL(InternalActionURL original) {
            super(original);
            this.interactionState = ParametersStateString.create((Map)ParameterMap.clone((Map)original.interactionState.getParameters()));
            this.navigationalState = original.navigationalState;
        }

        public StateString getInteractionState() {
            return this.interactionState;
        }

        @Override
        protected void setParameter(String name, String value) {
            this.interactionState.setValue(name, value);
        }

        @Override
        protected void setParameter(String name, String[] values) {
            this.interactionState.setValues(name, values);
        }

        @Override
        protected void setParameters(Map<String, String[]> parameters) {
            this.interactionState.replace(parameters);
        }

        @Override
        protected void removePublicRenderParameter(String name) {
        }

        @Override
        protected Map<String, String[]> getParameters() {
            return this.interactionState.getParameters();
        }

        public StateString getNavigationalState() {
            return this.navigationalState;
        }
    }

    private static abstract class InternalPortletURL
    extends BaseURLImpl.InternalContainerURL
    implements PortletURL {
        protected WindowState windowState;
        protected PortletMode portletMode;

        protected InternalPortletURL() {
            this.windowState = null;
            this.portletMode = null;
        }

        protected InternalPortletURL(InternalPortletURL original) {
            super(original);
            this.windowState = original.windowState;
            this.portletMode = original.portletMode;
        }

        public Mode getMode() {
            if (this.portletMode != null) {
                return Mode.create((String)this.portletMode.toString());
            }
            return null;
        }

        public org.gatein.pc.api.WindowState getWindowState() {
            if (this.windowState != null) {
                return org.gatein.pc.api.WindowState.create((String)this.windowState.toString());
            }
            return null;
        }

        protected abstract void removePublicRenderParameter(String var1);
    }
}

