/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.ecms.xcmis.sp.JcrConnection;
import org.exoplatform.ecms.xcmis.sp.RenditionsUpdateListener;
import org.exoplatform.ecms.xcmis.sp.StorageConfiguration;
import org.exoplatform.ecms.xcmis.sp.StorageImpl;
import org.exoplatform.ecms.xcmis.sp.TypeMapping;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.xcmis.search.SearchService;
import org.xcmis.search.SearchServiceException;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.StorageProvider;
import org.xcmis.spi.model.BaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageProviderImpl
implements StorageProvider,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)StorageProviderImpl.class.getName());
    private final RepositoryService repositoryService;
    private final PermissionService permissionService;
    private final CmisRegistry registry;
    private SearchService searchService;
    private StorageConfiguration storageConfiguration;
    Map<String, TypeMapping> nodeTypeMapping = new HashMap<String, TypeMapping>();
    public static final Map<String, TypeMapping> DEFAULT_NODETYPE_MAPPING;

    public StorageProviderImpl(RepositoryService repositoryService, PermissionService permissionService, CmisRegistry registry, InitParams initParams) {
        this(repositoryService, permissionService, registry, null, StorageProviderImpl.getStorageConfiguration(initParams));
    }

    private static StorageConfiguration getStorageConfiguration(InitParams initParams) {
        ObjectParameter param;
        StorageConfiguration storageConfiguration = null;
        if (initParams != null && (param = initParams.getObjectParam("configuration")) != null) {
            StorageProviderConfig confs = (StorageProviderConfig)param.getObject();
            storageConfiguration = confs.getStorage();
        }
        return storageConfiguration;
    }

    StorageProviderImpl(RepositoryService repositoryService, PermissionService permissionService, CmisRegistry registry, StorageConfiguration storageConfiguration) {
        this(repositoryService, permissionService, registry, null, storageConfiguration);
    }

    StorageProviderImpl(RepositoryService repositoryService, PermissionService permissionService, SearchService searchService, StorageConfiguration storageConfiguration) {
        this(repositoryService, permissionService, null, searchService, storageConfiguration);
    }

    StorageProviderImpl(RepositoryService repositoryService, PermissionService permissionService, CmisRegistry registry, SearchService searchService, StorageConfiguration storageConfiguration) {
        this.repositoryService = repositoryService;
        this.permissionService = permissionService;
        this.registry = registry;
        this.searchService = searchService;
        this.storageConfiguration = storageConfiguration;
        this.nodeTypeMapping.putAll(DEFAULT_NODETYPE_MAPPING);
    }

    public Connection getConnection() {
        if (this.storageConfiguration == null) {
            throw new InvalidArgumentException("CMIS repository is not configured.");
        }
        String ws = this.storageConfiguration.getWorkspace();
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = repository.login(ws);
            StorageImpl storage = new StorageImpl(session, this.storageConfiguration, this.searchService, this.permissionService, this.nodeTypeMapping);
            return new JcrConnection(storage);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get CMIS storage " + this.storageConfiguration.getId() + ". " + re.getMessage(), (Throwable)re);
        }
    }

    public Map<String, TypeMapping> getNodeTypeMapping() {
        return this.nodeTypeMapping;
    }

    public StorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public String getStorageID() {
        if (this.storageConfiguration == null) {
            throw new InvalidArgumentException("CMIS storage is not configured.");
        }
        return this.storageConfiguration.getId();
    }

    void setConfiguration(StorageConfiguration storageConfig) {
        if (this.storageConfiguration != null) {
            throw new IllegalStateException("Storage configuration already set.");
        }
        this.storageConfiguration = storageConfig;
    }

    public void start() {
        block2: {
            try {
                this.init();
                this.registry.addStorage((StorageProvider)this);
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unable to initialize storage. ", e);
            }
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void init() throws RepositoryException, RepositoryConfigurationException, SearchServiceException {
        block17: {
            if (this.storageConfiguration == null) {
                throw new CmisRuntimeException("CMIS repository is not configured.");
            }
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = repository.getSystemSession(this.storageConfiguration.getWorkspace());
            try {
                Node xCmisSystem;
                Node root = session.getRootNode();
                Node node = xCmisSystem = session.itemExists("/xcmis:system") ? (Node)session.getItem("/xcmis:system") : root.addNode("/xcmis:system".substring(1), "xcmis:system");
                if (!xCmisSystem.isNodeType("exo:hiddenable")) {
                    xCmisSystem.addMixin("exo:hiddenable");
                }
                if (!xCmisSystem.hasNode("xcmis:workingCopyStore")) {
                    xCmisSystem.addNode("xcmis:workingCopyStore", "xcmis:workingCopies");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"CMIS Working Copies store /xcmis:system/xcmis:workingCopyStore created.");
                    }
                }
                if (!xCmisSystem.hasNode("xcmis:relationshipStore")) {
                    xCmisSystem.addNode("xcmis:relationshipStore", "xcmis:relationships");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"CMIS relationship store /xcmis:system/xcmis:relationshipStore created.");
                    }
                }
                if (!xCmisSystem.hasNode("xcmis:policiesStore")) {
                    xCmisSystem.addNode("xcmis:policiesStore", "xcmis:policies");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"CMIS policies store /xcmis:system/xcmis:policiesStore created.");
                    }
                }
                session.save();
                Boolean persistRenditions = (Boolean)this.storageConfiguration.getProperties().get("exo.cmis.renditions.persistent");
                if (persistRenditions == null) {
                    persistRenditions = false;
                }
                if (!persistRenditions.booleanValue()) break block17;
                Workspace workspace = session.getWorkspace();
                try {
                    boolean exist = false;
                    WorkspaceContainerFacade workspaceContainer = ((RepositoryImpl)repository).getWorkspaceContainer(workspace.getName());
                    ObservationManagerRegistry observationManagerRegistry = (ObservationManagerRegistry)workspaceContainer.getComponent(ObservationManagerRegistry.class);
                    EventListenerIterator iter = observationManagerRegistry.getEventListeners();
                    while (iter.hasNext()) {
                        if (iter.nextEventListener().getClass() != RenditionsUpdateListener.class) continue;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        workspace.getObservationManager().addEventListener((EventListener)new RenditionsUpdateListener((Repository)repository, this.storageConfiguration.getWorkspace()), 20, "/", true, null, new String[]{"nt:resource"}, false);
                    }
                }
                catch (RepositoryException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Unable to create event listener. " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                session.logout();
            }
        }
    }

    void addNodeTypeMapping(Map<String, TypeMapping> nodeTypeMapping) {
        this.nodeTypeMapping.putAll(nodeTypeMapping);
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    static {
        HashMap<String, TypeMapping> aMap = new HashMap<String, TypeMapping>();
        aMap.put("nt:unstructured", new TypeMapping("nt:unstructured", BaseType.FOLDER, "cmis:folder"));
        aMap.put("exo:taxonomy", new TypeMapping("exo:taxonomy", BaseType.FOLDER, "cmis:folder"));
        DEFAULT_NODETYPE_MAPPING = Collections.unmodifiableMap(aMap);
    }

    public static class StorageProviderConfig {
        private StorageConfiguration storage;

        public StorageProviderConfig(StorageConfiguration storage) {
            this.storage = storage;
        }

        public StorageProviderConfig() {
        }

        public StorageConfiguration getStorage() {
            return this.storage;
        }

        public void setStorage(StorageConfiguration storage) {
            this.storage = storage;
        }
    }
}

