/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.filters.DefaultFilter;
import org.owasp.validator.css.CssScanner;
import org.owasp.validator.css.ExternalCssScanner;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Tag;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;

public class MagicSAXFilter
extends DefaultFilter
implements XMLDocumentFilter {
    private final Stack operations = new Stack();
    private ArrayList errorMessages = new ArrayList();
    private StringBuffer cssContent = null;
    private XMLAttributes cssAttributes = null;
    private CssScanner cssScanner = null;
    private Policy policy;
    private ResourceBundle messages;
    private boolean isNofollowAnchors;
    private boolean isValidateParamAsEmbed;
    private boolean inCdata = false;

    public MagicSAXFilter(Policy instance, ResourceBundle messages) {
        this.policy = instance;
        this.messages = messages;
        this.isNofollowAnchors = "true".equals(this.policy.getDirective("nofollowAnchors"));
        this.isValidateParamAsEmbed = "true".equals(this.policy.getDirective("validateParamAsEmbed"));
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.operations.empty() || !"remove".equals(this.operations.peek())) {
            if (!this.operations.empty() && "css".equals(this.operations.peek())) {
                this.cssContent.append(text.ch, text.offset, text.length);
            } else {
                if (this.inCdata) {
                    String encoded = HTMLEntityEncoder.htmlEntityEncode(text.toString());
                    this.addError("error.cdata.found", new Object[]{encoded});
                }
                super.characters(text, augs);
            }
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        String value;
        String preserveComments = this.policy.getDirective("preserveComments");
        if ("true".equals(preserveComments) && (value = text.toString()) != null) {
            value = value.replaceAll("<?!?\\[\\s*(?:end)?if[^]]*\\]>?", "");
            super.comment(new XMLString(value.toCharArray(), 0, value.length()), augs);
        }
    }

    public void doctypeDecl(String root, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (!this.operations.empty() && "remove".equals(this.operations.peek())) {
            this.operations.pop();
            return;
        } else if (!this.operations.empty() && "filter".equals(this.operations.peek())) {
            this.operations.pop();
            return;
        } else if (!this.operations.empty() && "css".equals(this.operations.peek())) {
            this.operations.pop();
            CssScanner cssScanner = this.makeCssScanner();
            try {
                CleanResults results = cssScanner.scanStyleSheet(this.cssContent.toString(), this.policy.getMaxInputSize());
                this.errorMessages.addAll(results.getErrorMessages());
                if (results.getCleanHTML() == null) return;
                if (results.getCleanHTML().equals("")) {
                    return;
                }
                super.startElement(element, this.cssAttributes, (Augmentations)new AugmentationsImpl());
                super.characters((XMLString)new XMLStringBuffer(results.getCleanHTML()), (Augmentations)new AugmentationsImpl());
                super.endElement(element, augs);
                return;
            }
            catch (ScanException e) {
                this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(this.cssContent.toString())});
                return;
            }
            finally {
                this.cssContent = null;
                this.cssAttributes = null;
            }
        } else {
            this.operations.pop();
            super.endElement(element, augs);
        }
    }

    private CssScanner makeCssScanner() {
        if (this.cssScanner == null) {
            this.cssScanner = "true".equals(this.policy.getDirective("embedStyleSheets")) ? new ExternalCssScanner(this.policy, this.messages) : new CssScanner(this.policy, this.messages);
        }
        return this.cssScanner;
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.inCdata = true;
        super.startCDATA(augs);
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.inCdata = false;
        super.endCDATA(augs);
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Tag embedPolicy;
        Tag tag = this.policy.getTagByName(element.localpart);
        boolean masqueradingParam = false;
        String embedName = null;
        String embedValue = null;
        if (tag == null && this.isValidateParamAsEmbed && "param".equals(element.localpart.toLowerCase()) && (embedPolicy = this.policy.getTagByName("embed")) != null && "validate".equals(embedPolicy.getAction())) {
            tag = embedPolicy;
            masqueradingParam = true;
            embedName = attributes.getValue("name");
            embedValue = attributes.getValue("value");
            XMLAttributesImpl masqueradingAttrs = new XMLAttributesImpl();
            masqueradingAttrs.addAttribute(this.makeSimpleQname(embedName), "CDATA", embedValue);
            attributes = masqueradingAttrs;
        }
        XMLAttributesImpl validattributes = new XMLAttributesImpl();
        if (!this.operations.isEmpty() && ("remove".equals(this.operations.peek()) || "css".equals(this.operations.peek()))) {
            this.operations.push("remove");
        } else if (tag == null && "encode".equals(this.policy.getDirective("onUnknownTag")) || tag != null && "encode".equals(tag.getAction())) {
            String name = "<" + element.localpart + ">";
            super.characters(new XMLString(name.toCharArray(), 0, name.length()), augs);
            this.operations.push("filter");
        } else if (tag == null) {
            this.addError("error.tag.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(element.localpart)});
            this.operations.push("filter");
        } else if ("filter".equals(tag.getAction())) {
            this.addError("error.tag.filtered", new Object[]{HTMLEntityEncoder.htmlEntityEncode(element.localpart)});
            this.operations.push("filter");
        } else if ("validate".equals(tag.getAction())) {
            boolean isStyle = "style".endsWith(element.localpart);
            if (isStyle) {
                this.operations.push("css");
                this.cssContent = new StringBuffer();
                this.cssAttributes = attributes;
            } else {
                boolean removeTag = false;
                boolean filterTag = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    Attribute attribute = tag.getAttributeByName(name.toLowerCase());
                    if (attribute == null) {
                        attribute = this.policy.getGlobalAttributeByName(name.toLowerCase());
                    }
                    if ("style".equalsIgnoreCase(name)) {
                        CssScanner styleScanner = this.makeCssScanner();
                        try {
                            CleanResults cr = styleScanner.scanInlineStyle(value, element.localpart, this.policy.getMaxInputSize());
                            attributes.setValue(i, cr.getCleanHTML());
                            validattributes.addAttribute(this.makeSimpleQname(name), "CDATA", cr.getCleanHTML());
                            this.errorMessages.addAll(cr.getErrorMessages());
                        }
                        catch (ScanException e) {
                            this.addError("error.css.attribute.malformed", new Object[]{element.localpart, HTMLEntityEncoder.htmlEntityEncode(value)});
                        }
                        continue;
                    }
                    if (attribute != null) {
                        boolean isValid = false;
                        Iterator allowedValues = attribute.getAllowedValues().iterator();
                        while (allowedValues.hasNext()) {
                            String allowedValue = (String)allowedValues.next();
                            if (allowedValue == null || !allowedValue.equalsIgnoreCase(value)) continue;
                            validattributes.addAttribute(this.makeSimpleQname(name), "CDATA", value);
                            isValid = true;
                            break;
                        }
                        Iterator allowedRexexps = attribute.getAllowedRegExp().iterator();
                        while (!isValid && allowedRexexps.hasNext()) {
                            Pattern pattern = (Pattern)allowedRexexps.next();
                            if (pattern == null || !pattern.matcher(value.toLowerCase()).matches()) continue;
                            validattributes.addAttribute(this.makeSimpleQname(name), "CDATA", value);
                            isValid = true;
                            break;
                        }
                        if (!isValid && "removeTag".equals(attribute.getOnInvalid())) {
                            this.addError("error.attribute.invalid.removed", new Object[]{tag.getName(), HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                            removeTag = true;
                            continue;
                        }
                        if (!isValid && ("filterTag".equals(attribute.getOnInvalid()) || masqueradingParam)) {
                            this.addError("error.attribute.invalid.filtered", new Object[]{tag.getName(), HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                            filterTag = true;
                            continue;
                        }
                        if (isValid) continue;
                        this.addError("error.attribute.invalid", new Object[]{tag.getName(), HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                        continue;
                    }
                    this.addError("error.attribute.notfound", new Object[]{element.localpart, HTMLEntityEncoder.htmlEntityEncode(name), HTMLEntityEncoder.htmlEntityEncode(value)});
                    if (!masqueradingParam) continue;
                    filterTag = true;
                }
                if (removeTag) {
                    this.operations.push("remove");
                } else if (filterTag) {
                    this.operations.push("filter");
                } else {
                    if (this.isNofollowAnchors && "a".equals(element.localpart)) {
                        validattributes.addAttribute(this.makeSimpleQname("rel"), "CDATA", "nofollow");
                    }
                    if (masqueradingParam) {
                        validattributes = new XMLAttributesImpl();
                        validattributes.addAttribute(this.makeSimpleQname("name"), "CDATA", embedName);
                        validattributes.addAttribute(this.makeSimpleQname("value"), "CDATA", embedValue);
                    }
                    this.operations.push("keep");
                }
            }
        } else if ("truncate".equals(tag.getAction())) {
            this.operations.push("truncate");
        } else {
            this.addError("error.tag.removed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(element.localpart)});
            this.operations.push("remove");
        }
        if ("truncate".equals(this.operations.peek())) {
            super.startElement(element, (XMLAttributes)new XMLAttributesImpl(), augs);
        } else if ("keep".equals(this.operations.peek())) {
            super.startElement(element, (XMLAttributes)validattributes, augs);
        }
    }

    private QName makeSimpleQname(String name) {
        return new QName("", name, name, "");
    }

    private void addError(String errorKey, Object[] objs) {
        this.errorMessages.add(ErrorMessageUtil.getMessage(this.messages, errorKey, objs));
    }

    public ArrayList getErrorMessages() {
        return this.errorMessages;
    }
}

