/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.util;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static String getAttributeValue(Element ele, String attrName) {
        return XMLUtil.decode(ele.getAttribute(attrName));
    }

    public static int getIntValue(Element ele, String tagName, int defaultValue) {
        int toReturn = defaultValue;
        try {
            toReturn = Integer.parseInt(XMLUtil.getTextValue(ele, tagName));
        }
        catch (Throwable t) {
            // empty catch block
        }
        return toReturn;
    }

    public static String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild() != null ? el.getFirstChild().getNodeValue() : "";
        }
        return XMLUtil.decode(textVal);
    }

    public static boolean getBooleanValue(Element ele, String tagName) {
        boolean boolVal = false;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            boolVal = el.getFirstChild().getNodeValue().equals("true");
        }
        return boolVal;
    }

    public static boolean getBooleanValue(Element ele, String tagName, boolean defaultValue) {
        boolean boolVal = defaultValue;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            boolVal = el.getFirstChild().getNodeValue() != null ? "true".equals(el.getFirstChild().getNodeValue()) : defaultValue;
        }
        return boolVal;
    }

    public static String decode(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&amp;", "&");
        return str;
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("&", "&amp;");
        return str;
    }
}

