/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import org.jbpm.JbpmException;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ConstructorInfo;
import org.jbpm.configuration.FieldInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.PropertyInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class BeanInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    String className = null;
    ConstructorInfo constructorInfo = null;
    PropertyInfo[] propertyInfos = null;

    public BeanInfo() {
    }

    public BeanInfo(Element beanElement, ObjectFactoryParser objectFactoryParser) {
        super(beanElement, objectFactoryParser);
        Element constructorElement = XmlUtil.element(beanElement, "constructor");
        if (constructorElement != null) {
            this.constructorInfo = new ConstructorInfo(constructorElement, objectFactoryParser);
            this.constructorInfo.beanInfo = this;
        }
        if (beanElement.hasAttribute("class")) {
            this.className = beanElement.getAttribute("class");
        } else if (this.constructorInfo.factoryRefName == null && this.constructorInfo.factoryClassName == null) {
            throw new JbpmException("bean element must have a class attribute: " + XmlUtil.toString(beanElement));
        }
        ArrayList<PropertyInfo> propertyInfoList = new ArrayList<PropertyInfo>();
        Iterator iter = XmlUtil.elementIterator(beanElement, "field");
        while (iter.hasNext()) {
            Element fieldElement = (Element)iter.next();
            propertyInfoList.add(new FieldInfo(fieldElement, objectFactoryParser));
        }
        iter = XmlUtil.elementIterator(beanElement, "property");
        while (iter.hasNext()) {
            Element propertyElement = (Element)iter.next();
            propertyInfoList.add(new PropertyInfo(propertyElement, objectFactoryParser));
        }
        this.propertyInfos = propertyInfoList.toArray(new PropertyInfo[propertyInfoList.size()]);
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        Object object = null;
        if (this.constructorInfo == null) {
            if (this.className == null) {
                throw new JbpmException("bean '" + this.getName() + "' doesn't have a class or constructor specified");
            }
            try {
                Class clazz = objectFactory.classForName(this.className);
                object = clazz.newInstance();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't instantiate bean '" + this.getName() + "' of type '" + this.className + "'", e);
            }
        } else {
            object = this.constructorInfo.createObject(objectFactory);
        }
        if (this.className == null) {
            this.className = object.getClass().getName();
        }
        if (this.propertyInfos != null) {
            for (int i = 0; i < this.propertyInfos.length; ++i) {
                this.propertyInfos[i].injectProperty(object, objectFactory);
            }
        }
        return object;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

