/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserEventListenerHandler;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.hibernate.HibernateListAccess;
import org.exoplatform.services.organization.hibernate.MembershipDAOImpl;
import org.exoplatform.services.organization.hibernate.UserProfileDAOImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.security.PasswordEncrypter;
import org.exoplatform.services.security.PermissionConstants;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAOImpl
implements UserHandler,
UserEventListenerHandler,
ExtendedUserHandler {
    public static final String queryFindUserByName = "from u in class org.exoplatform.services.organization.impl.UserImpl where u.userName = ?";
    private HibernateService service_;
    private ExoCache cache_;
    private List<UserEventListener> listeners_ = new ArrayList<UserEventListener>(3);
    private OrganizationService orgService;

    public UserDAOImpl(HibernateService service, CacheService cservice, OrganizationService orgService) throws Exception {
        this.service_ = service;
        this.cache_ = cservice.getCacheInstance(UserImpl.class.getName());
        this.orgService = orgService;
    }

    public final List getUserEventListeners() {
        return this.listeners_;
    }

    public void addUserEventListener(UserEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners_.add(listener);
    }

    public void removeUserEventListener(UserEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners_.remove(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(user, true);
        }
        Session session = this.service_.openSession();
        UserImpl userImpl = (UserImpl)user;
        userImpl.setId(user.getUserName());
        session.save((Object)user);
        session.flush();
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(user, false);
        }
        Session session = this.service_.openSession();
        session.merge((Object)user);
        session.flush();
        this.cache_.put((Serializable)((Object)user.getUserName()), (Object)user);
        if (broadcast) {
            this.postSave(user, false);
        }
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        User foundUser = this.findUserByName(userName, session);
        if (foundUser == null) {
            return null;
        }
        if (broadcast) {
            this.preDelete(foundUser);
        }
        session.delete((Object)foundUser);
        ((UserProfileDAOImpl)this.orgService.getUserProfileHandler()).removeUserProfileEntry(userName, session);
        MembershipDAOImpl.removeMembershipEntriesOfUser(userName, session);
        session.flush();
        this.cache_.remove((Serializable)((Object)userName));
        if (broadcast) {
            this.postDelete(foundUser);
        }
        return foundUser;
    }

    public User findUserByName(String userName) throws Exception {
        User user = (User)this.cache_.get((Serializable)((Object)userName));
        if (user != null) {
            return user;
        }
        Session session = this.service_.openSession();
        user = this.findUserByName(userName, session);
        if (user != null) {
            this.cache_.put((Serializable)((Object)userName), (Object)user);
        }
        return user;
    }

    public User findUserByName(String userName, Session session) throws Exception {
        User user = (User)this.service_.findOne(session, queryFindUserByName, userName);
        return user;
    }

    public LazyPageList<User> getUserPageList(int pageSize) throws Exception {
        return new LazyPageList(this.findAllUsers(), 20);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        String findQuery = "from o in class " + UserImpl.class.getName();
        String countQuery = "select count(o) from " + UserImpl.class.getName() + " o";
        return new HibernateListAccess<User>(this.service_, findQuery, countQuery);
    }

    public boolean authenticate(String username, String password) throws Exception {
        return this.authenticate(username, password, null);
    }

    public boolean authenticate(String username, String password, PasswordEncrypter pe) throws Exception {
        boolean authenticated;
        User user = this.findUserByName(username);
        if (user == null) {
            return false;
        }
        if (pe == null) {
            authenticated = user.getPassword().equals(password);
        } else {
            String encryptedPassword = new String(pe.encrypt(user.getPassword().getBytes()));
            authenticated = encryptedPassword.equals(password);
        }
        if (authenticated) {
            UserImpl userImpl = (UserImpl)user;
            userImpl.setLastLoginTime(Calendar.getInstance().getTime());
            this.saveUser((User)userImpl, false);
        }
        return authenticated;
    }

    public LazyPageList<User> findUsers(Query q) throws Exception {
        return new LazyPageList(this.findUsersByQuery(q), 20);
    }

    public ListAccess<User> findUsersByQuery(Query q) throws Exception {
        ObjectQuery oq = new ObjectQuery(UserImpl.class);
        if (q.getUserName() != null) {
            oq.addLIKE("UPPER(userName)", this.addAsterisk(q.getUserName().toUpperCase()));
        }
        if (q.getFirstName() != null) {
            oq.addLIKE("UPPER(firstName)", q.getFirstName().toUpperCase());
        }
        if (q.getLastName() != null) {
            oq.addLIKE("UPPER(lastName)", q.getLastName().toUpperCase());
        }
        oq.addLIKE("email", q.getEmail());
        oq.addGT("lastLoginTime", (Object)q.getFromLoginDate());
        oq.addLT("lastLoginTime", (Object)q.getToLoginDate());
        return new HibernateListAccess<User>(this.service_, oq.getHibernateQueryWithBinding(), oq.getHibernateCountQueryWithBinding(), oq.getBindingFields());
    }

    public LazyPageList<User> findUsersByGroup(String groupId) throws Exception {
        return new LazyPageList(this.findUsersByGroupId(groupId), 20);
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        String queryFindUsersInGroup = "select u from u in class org.exoplatform.services.organization.impl.UserImpl,      m in class org.exoplatform.services.organization.impl.MembershipImpl where m.userName = u.userName      and m.groupId =  '" + groupId + "'";
        String countUsersInGroup = "select count(u) from u in class org.exoplatform.services.organization.impl.UserImpl,      m in class org.exoplatform.services.organization.impl.MembershipImpl where m.userName = u.userName   and m.groupId =  '" + groupId + "'";
        return new HibernateListAccess<User>(this.service_, queryFindUsersInGroup, countUsersInGroup);
    }

    public Collection findUsersByGroupAndRole(String groupName, String role) throws Exception {
        String queryFindUsersByGroupAndRole = "select u from u in class org.exoplatform.services.organization.impl.UserImpl,      m in class org.exoplatform.services.organization.impl.MembershipImpl,      g in class org.exoplatform.services.organization.impl.GroupImpl where m.user = u   and m.group = g   and g.groupName = ?   and m.role = ? ";
        Session session = this.service_.openSession();
        org.hibernate.Query q = session.createQuery(queryFindUsersByGroupAndRole).setString(0, groupName).setString(1, role);
        List users = q.list();
        return users;
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postDelete(user);
        }
    }

    private String addAsterisk(String s) {
        StringBuffer sb = new StringBuffer(s);
        if (!s.startsWith("*")) {
            sb.insert(0, "*");
        }
        if (!s.endsWith("*")) {
            sb.append("*");
        }
        return sb.toString();
    }

    public List<UserEventListener> getUserListeners() {
        return Collections.unmodifiableList(this.listeners_);
    }
}

