/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationContext {
    private static final Log log = LogFactory.getLog(InvocationContext.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transaction transaction;
    private GlobalTransaction globalTransaction;
    protected TransactionContext transactionContext;
    private Option optionOverrides;
    private boolean originLocal = true;
    private boolean localRollbackOnly;
    private boolean bypassUnmarshalling = false;
    @Deprecated
    private MethodCall methodCall;
    @Deprecated
    private VisitableCommand command;
    private Set<Fqn> fqnsLoaded;
    protected LinkedHashSet invocationLocks;

    public abstract NodeSPI lookUpNode(Fqn var1);

    public abstract void putLookedUpNode(Fqn var1, NodeSPI var2);

    public abstract void putLookedUpNodes(Map<Fqn, NodeSPI> var1);

    public abstract void clearLookedUpNodes();

    public abstract Map<Fqn, NodeSPI> getLookedUpNodes();

    public void setLocalRollbackOnly(boolean localRollbackOnly) {
        this.localRollbackOnly = localRollbackOnly;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public Option getOptionOverrides() {
        if (this.optionOverrides == null) {
            this.optionOverrides = new Option();
        }
        return this.optionOverrides;
    }

    public boolean isOptionsUninitialised() {
        return this.optionOverrides == null;
    }

    public void setOptionOverrides(Option optionOverrides) {
        this.optionOverrides = optionOverrides;
    }

    public boolean isOriginLocal() {
        return this.originLocal;
    }

    public List getLocks() {
        if (this.transactionContext != null) {
            return this.transactionContext.getLocks();
        }
        return this.invocationLocks == null || this.invocationLocks.isEmpty() ? Collections.emptyList() : Immutables.immutableListConvert(this.invocationLocks);
    }

    public void addAllLocks(List locks) {
        if (this.transactionContext != null) {
            this.transactionContext.addAllLocks(locks);
        } else {
            if (this.invocationLocks == null) {
                this.invocationLocks = new LinkedHashSet(4);
            }
            this.invocationLocks.addAll(locks);
        }
    }

    public void addLock(Object lock) {
        if (this.transactionContext != null) {
            this.transactionContext.addLock(lock);
        } else {
            if (this.invocationLocks == null) {
                this.invocationLocks = new LinkedHashSet(4);
            }
            this.invocationLocks.add(lock);
        }
    }

    public void removeLock(Object lock) {
        if (this.transactionContext != null) {
            this.transactionContext.removeLock(lock);
        } else if (this.invocationLocks != null) {
            this.invocationLocks.remove(lock);
        }
    }

    public void clearLocks() {
        if (this.transactionContext != null) {
            this.transactionContext.clearLocks();
        } else if (this.invocationLocks != null) {
            this.invocationLocks.clear();
        }
    }

    public boolean hasLock(Object lock) {
        if (this.transactionContext != null) {
            return this.transactionContext.hasLock(lock);
        }
        return this.invocationLocks != null && this.invocationLocks.contains(lock);
    }

    public boolean isLockingSuppressed() {
        return this.getOptionOverrides() != null && this.getOptionOverrides().isSuppressLocking();
    }

    public void setOriginLocal(boolean originLocal) {
        this.originLocal = originLocal;
    }

    public boolean isLocalRollbackOnly() {
        return this.localRollbackOnly;
    }

    public void reset() {
        this.transaction = null;
        this.globalTransaction = null;
        this.optionOverrides = null;
        this.originLocal = true;
        this.invocationLocks = null;
        this.methodCall = null;
        this.command = null;
        this.fqnsLoaded = null;
        this.bypassUnmarshalling = false;
    }

    public abstract InvocationContext copy();

    public void setState(InvocationContext template) {
        if (template == null) {
            throw new NullPointerException("Template InvocationContext passed in to InvocationContext.setState() passed in is null");
        }
        this.setGlobalTransaction(template.getGlobalTransaction());
        this.setLocalRollbackOnly(template.isLocalRollbackOnly());
        this.setOptionOverrides(template.getOptionOverrides());
        this.setOriginLocal(template.isOriginLocal());
        this.setTransaction(template.getTransaction());
    }

    @Deprecated
    public MethodCall getMethodCall() {
        if (this.methodCall == null) {
            this.methodCall = this.createMethodCall();
        }
        return this.methodCall;
    }

    private MethodCall createMethodCall() {
        if (this.command == null) {
            return null;
        }
        MethodCall call = new MethodCall();
        call.setMethodId(this.command.getCommandId());
        call.setArgs(this.command.getParameters());
        return call;
    }

    @Deprecated
    public void setMethodCall(MethodCall methodCall) {
        this.methodCall = methodCall;
    }

    public long getLockAcquisitionTimeout(long timeout) {
        if (this.getOptionOverrides() != null && this.getOptionOverrides().getLockAcquisitionTimeout() >= 0) {
            timeout = this.getOptionOverrides().getLockAcquisitionTimeout();
        }
        return timeout;
    }

    @Deprecated
    public void setCommand(VisitableCommand cacheCommand) {
        this.command = cacheCommand;
    }

    @Deprecated
    public VisitableCommand getCommand() {
        return this.command;
    }

    public boolean isValidTransaction() {
        return this.transaction != null && TransactionTable.isValid(this.transaction);
    }

    public void throwIfNeeded(Throwable e) throws Throwable {
        boolean shouldRethtrow;
        Option optionOverride = this.getOptionOverrides();
        boolean bl = shouldRethtrow = optionOverride == null || !optionOverride.isFailSilently();
        if (!shouldRethtrow) {
            if (trace) {
                log.trace((Object)"There was a problem handling this request, but failSilently was set, so suppressing exception", e);
            }
            return;
        }
        throw e;
    }

    protected void doCopy(InvocationContext copy) {
        copy.command = this.command;
        copy.globalTransaction = this.globalTransaction;
        copy.invocationLocks = this.invocationLocks == null ? null : new LinkedHashSet(this.invocationLocks);
        copy.localRollbackOnly = this.localRollbackOnly;
        copy.optionOverrides = this.optionOverrides == null ? null : this.optionOverrides.copy();
        copy.originLocal = this.originLocal;
        copy.transaction = this.transaction;
        copy.transactionContext = this.transactionContext;
        copy.fqnsLoaded = this.fqnsLoaded;
        copy.bypassUnmarshalling = this.bypassUnmarshalling;
    }

    public void addFqnLoaded(Fqn fqn) {
        if (this.fqnsLoaded == null) {
            this.fqnsLoaded = new HashSet<Fqn>();
        }
        this.fqnsLoaded.add(fqn);
    }

    public Set<Fqn> getFqnsLoaded() {
        return this.fqnsLoaded;
    }

    public void setFqnsLoaded(Set<Fqn> fqnsLoaded) {
        this.fqnsLoaded = fqnsLoaded;
    }

    public String toString() {
        return "InvocationContext{transaction=" + this.transaction + ", globalTransaction=" + this.globalTransaction + ", transactionContext=" + this.transactionContext + ", optionOverrides=" + this.optionOverrides + ", originLocal=" + this.originLocal + ", bypassUnmarshalling=" + this.bypassUnmarshalling + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationContext that = (InvocationContext)o;
        if (this.localRollbackOnly != that.localRollbackOnly) {
            return false;
        }
        if (this.bypassUnmarshalling != that.bypassUnmarshalling) {
            return false;
        }
        if (this.originLocal != that.originLocal) {
            return false;
        }
        if (this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null) {
            return false;
        }
        if (this.optionOverrides != null ? !this.optionOverrides.equals(that.optionOverrides) : that.optionOverrides != null) {
            return false;
        }
        return !(this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null);
    }

    public int hashCode() {
        int result = this.transaction != null ? this.transaction.hashCode() : 0;
        result = 29 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 29 * result + (this.optionOverrides != null ? this.optionOverrides.hashCode() : 0);
        result = 29 * result + (this.originLocal ? 1 : 0);
        result = 29 * result + (this.localRollbackOnly ? 1 : 0);
        result = 29 * result + (this.bypassUnmarshalling ? 1 : 0);
        return result;
    }

    public void setBypassUnmarshalling(boolean b) {
        this.bypassUnmarshalling = b;
    }

    public boolean isBypassUnmarshalling() {
        return this.bypassUnmarshalling;
    }
}

