/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.REST.presentation.document.edit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.comparator.PropertyValueComparator;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/presentation/document/edit/")
public class GetEditedDocumentRESTService
implements ResourceContainer {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private RepositoryService repositoryService;
    private TemplateService templateService;
    private NewFolksonomyService newFolksonomyService;
    private ManageDriveService manageDriveService;
    private static final String DATE_MODIFIED = "exo:dateModified";
    private static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    private static final String NT_BASE = "nt:base";
    private static final String EXO_OWNER = "exo:owner";
    private static final int NO_PER_PAGE = 5;
    private static final String QUERY_STATEMENT = "SELECT * FROM $0 WHERE $1 ORDER BY $2 DESC";
    private static final String GADGET = "gadgets";
    private boolean show_gadget = false;
    private static final Log LOG = ExoLogger.getLogger((String)GetEditedDocumentRESTService.class.getName());

    public GetEditedDocumentRESTService(RepositoryService repositoryService, TemplateService templateService, NewFolksonomyService newFolksonomyService, ManageDriveService manageDriveService) {
        this.repositoryService = repositoryService;
        this.templateService = templateService;
        this.newFolksonomyService = newFolksonomyService;
        this.manageDriveService = manageDriveService;
    }

    @Path(value="/{repository}/")
    @GET
    public Response getLastEditedDoc(@PathParam(value="repository") String repository, @QueryParam(value="showItems") String showItems, @QueryParam(value="showGadgetWs") String showGadgetWs) throws Exception {
        List<Node> lstLastEditedNode = this.getLastEditedNode(showItems, showGadgetWs);
        List<DocumentNode> lstDocNode = this.getDocumentData(lstLastEditedNode);
        ListEditDocumentNode listEditDocumentNode = new ListEditDocumentNode();
        listEditDocumentNode.setLstDocNode(lstDocNode);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)listEditDocumentNode, (MediaType)new MediaType("application", "json")).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private List<Node> getLastEditedNode(String noOfItem, String showGadgetWs) throws Exception {
        ArrayList<Node> lstNode;
        block9: {
            if (showGadgetWs != null && showGadgetWs.length() > 0) {
                this.show_gadget = Boolean.parseBoolean(showGadgetWs);
            }
            lstNode = new ArrayList<Node>();
            StringBuffer bf = new StringBuffer(1024);
            List lstNodeType = this.templateService.getDocumentTemplates();
            if (lstNodeType != null) {
                for (String nodeType : lstNodeType) {
                    bf.append("(").append(JCR_PRIMARYTYPE).append("=").append("'").append(nodeType).append("'").append(")").append(" OR ");
                }
            }
            if (bf.length() == 1) {
                return null;
            }
            bf.delete(bf.lastIndexOf("OR") - 1, bf.length());
            if (noOfItem == null || noOfItem.trim().length() == 0) {
                noOfItem = String.valueOf(5);
            }
            String queryStatement = StringUtils.replace((String)QUERY_STATEMENT, (String)"$0", (String)NT_BASE);
            queryStatement = StringUtils.replace((String)queryStatement, (String)"$1", (String)bf.toString());
            queryStatement = StringUtils.replace((String)queryStatement, (String)"$2", (String)DATE_MODIFIED);
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            try {
                String[] workspaces = manageableRepository.getWorkspaceNames();
                ArrayList<String> lstWorkspace = new ArrayList<String>();
                lstWorkspace.addAll(Arrays.asList(workspaces));
                if (!this.show_gadget && lstWorkspace.contains(GADGET)) {
                    lstWorkspace.remove(GADGET);
                }
                SessionProvider provider = WCMCoreUtils.createAnonimProvider();
                QueryImpl query = null;
                Session session = null;
                QueryResult queryResult = null;
                QueryManager queryManager = null;
                for (String workspace : lstWorkspace) {
                    session = provider.getSession(workspace, manageableRepository);
                    queryManager = session.getWorkspace().getQueryManager();
                    query = (QueryImpl)queryManager.createQuery(queryStatement, "sql");
                    query.setLimit((long)Integer.parseInt(noOfItem));
                    query.setOffset(0L);
                    queryResult = query.execute();
                    this.puttoList(lstNode, queryResult.getNodes());
                    session.logout();
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)("Exception when execute SQL " + queryStatement), (Throwable)e);
            }
        }
        return lstNode;
    }

    private void puttoList(List<Node> lstNode, NodeIterator nodeIter) {
        if (nodeIter != null) {
            while (nodeIter.hasNext()) {
                lstNode.add(nodeIter.nextNode());
            }
        }
    }

    private List<DocumentNode> getDocumentData(List<Node> lstNode) throws Exception {
        return this.getDocumentData(lstNode, String.valueOf(5));
    }

    private String getDateFormat(Calendar date) {
        return String.valueOf(date.getTimeInMillis());
    }

    private List<DocumentNode> getDocumentData(List<Node> lstNode, String noOfItem) throws Exception {
        if (lstNode == null || lstNode.size() == 0) {
            return null;
        }
        ArrayList<DocumentNode> lstDocNode = new ArrayList<DocumentNode>();
        DocumentNode docNode = null;
        StringBuilder tags = null;
        Collections.sort(lstNode, new PropertyValueComparator(DATE_MODIFIED, "Descending"));
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        List lstDrive = this.manageDriveService.getAllDrives();
        for (Node node : lstNode) {
            docNode = new DocumentNode();
            docNode.setName(node.getName());
            docNode.setPath(node.getPath());
            docNode.setLastAuthor(node.getProperty(EXO_OWNER).getString());
            docNode.setLstAuthor(node.getProperty(EXO_OWNER).getString());
            docNode.setDateEdited(this.getDateFormat(node.getProperty(DATE_MODIFIED).getDate()));
            tags = new StringBuilder(1024);
            List tagList = this.newFolksonomyService.getLinkedTagsOfDocumentByScope(0, "", node, manageableRepository.getConfiguration().getDefaultWorkspaceName());
            for (Node tag : tagList) {
                tags.append(tag.getName()).append(", ");
            }
            if (tags.lastIndexOf(",") > 0) {
                tags.delete(tags.lastIndexOf(","), tags.length());
            }
            docNode.setTags(tags.toString());
            docNode.setDriveName(this.getDriveName(lstDrive, node));
            if (lstDocNode.size() >= Integer.parseInt(noOfItem)) continue;
            lstDocNode.add(docNode);
        }
        return lstDocNode;
    }

    private String getDriveName(List<DriveData> lstDrive, Node node) throws RepositoryException {
        String driveName = "";
        for (DriveData drive : lstDrive) {
            if (!node.getSession().getWorkspace().getName().equals(drive.getWorkspace()) || !node.getPath().contains(drive.getHomePath()) || !drive.getHomePath().equals("/")) continue;
            driveName = drive.getName();
            break;
        }
        return driveName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListEditDocumentNode {
        private List<DocumentNode> lstDocNode;

        public List<DocumentNode> getLstDocNode() {
            return this.lstDocNode;
        }

        public void setLstDocNode(List<DocumentNode> lstDocNode) {
            this.lstDocNode = lstDocNode;
        }
    }

    public class DocumentNode {
        private String nodeName_;
        private String nodePath_;
        private String driveName_;
        private String dateEdited_;
        private String tags;
        private String lastAuthor;
        private String lstAuthor;

        public String getTags() {
            return this.tags;
        }

        public void setTags(String tags) {
            this.tags = tags;
        }

        public String getLastAuthor() {
            return this.lastAuthor;
        }

        public void setLastAuthor(String lastAuthor) {
            this.lastAuthor = lastAuthor;
        }

        public String getLstAuthor() {
            return this.lstAuthor;
        }

        public void setLstAuthor(String lstAuthor) {
            this.lstAuthor = lstAuthor;
        }

        public void setName(String nodeName) {
            this.nodeName_ = nodeName;
        }

        public String getName() {
            return this.nodeName_;
        }

        public void setPath(String nodePath) {
            this.nodePath_ = nodePath;
        }

        public String getPath() {
            return this.nodePath_;
        }

        public void setDriveName(String driveName) {
            this.driveName_ = driveName;
        }

        public String getDriveName() {
            return this.driveName_;
        }

        public String getDateEdited() {
            return this.dateEdited_;
        }

        public void setDateEdited(String dateEdited_) {
            this.dateEdited_ = dateEdited_;
        }
    }
}

