/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.NotInWCMPublicationException;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMPublicationServiceImpl
implements WCMPublicationService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)WCMPublicationServiceImpl.class.getName());
    private static final String SIMPLE_LIFECYCLE_NAME = "Simple publication";
    public static final String STATEVERSION_LIFECYCLE_NAME = "States and versions based publication";
    private HashMap<String, WebpagePublicationPlugin> publicationPlugins = new HashMap();
    protected PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
    protected ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
    protected CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);

    @Override
    public void addPublicationPlugin(WebpagePublicationPlugin p) {
        this.publicationPlugins.put(p.getLifecycleName(), p);
        this.publicationService.addPublicationPlugin((PublicationPlugin)((Object)PublicationPlugin.class.cast((Object)p)));
    }

    @Override
    public void suspendPublishedContentFromPage(Node content, Page page, String remoteUser) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(content)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(content);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        publicationPlugin.suspendPublishedContentFromPage(content, page, remoteUser);
    }

    @Override
    public void publishContentSCV(Node content, Page page, String portalOwnerName) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(content)) {
            throw new NotInPublicationLifecycleException("The node " + content.getPath() + " is not enrolled to any publication lifecyle");
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(content);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        publicationPlugin.publishContentToSCV(content, page, portalOwnerName);
    }

    @Override
    public void publishContentCLV(Node content, Page page, String clvPortletId, String portalOwnerName, String remoteUser) throws Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(content)) {
            throw new NotInPublicationLifecycleException("The node " + content.getPath() + " is not enrolled to any publication lifecyle");
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(content);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        publicationPlugin.publishContentToCLV(content, page, clvPortletId, portalOwnerName, remoteUser);
    }

    @Override
    public void enrollNodeInLifecycle(Node node, String lifecycleName) throws Exception {
        this.publicationService.enrollNodeInLifecycle(node, lifecycleName);
    }

    @Override
    public void unsubcribeLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        this.publicationService.unsubcribeLifecycle(node);
    }

    @Override
    public Map<String, WebpagePublicationPlugin> getWebpagePublicationPlugins() {
        return this.publicationPlugins;
    }

    @Override
    public void updateLifecycleOnChangeNavigation(NavigationContext navigationContext, String remoteUser) {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            try {
                publicationPlugin.updateLifecycleOnChangeNavigation(navigationContext, remoteUser);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void updateLifecycleOnRemovePage(Page page, String remoteUser) {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            try {
                publicationPlugin.updateLifecycleOnRemovePage(page, remoteUser);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void updateLifecyleOnChangePage(Page page, String remoteUser) {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            try {
                publicationPlugin.updateLifecyleOnChangePage(page, remoteUser);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void updateLifecyleOnCreateNavigation(NavigationContext navigationContext) {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            try {
                publicationPlugin.updateLifecyleOnCreateNavigation(navigationContext);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void updateLifecyleOnCreatePage(Page page, String remoteUser) {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            try {
                publicationPlugin.updateLifecyleOnCreatePage(page, remoteUser);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void updateLifecyleOnRemoveNavigation(NavigationContext navigationContext) {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            try {
                publicationPlugin.updateLifecyleOnRemoveNavigation(navigationContext);
            }
            catch (Exception e) {}
        }
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public boolean isEnrolledInWCMLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            return false;
        }
        String lifecyleName = this.publicationService.getNodeLifecycleName(node);
        if (this.publicationPlugins.containsKey(lifecyleName)) {
            return true;
        }
        throw new NotInWCMPublicationException();
    }

    @Override
    public void enrollNodeInLifecycle(Node node, String siteName, String remoteUser) throws Exception {
        if ("test".equals(siteName)) {
            this.enrollNodeInLifecycle(node, SIMPLE_LIFECYCLE_NAME);
        } else {
            this.enrollNodeInLifecycle(node, STATEVERSION_LIFECYCLE_NAME);
        }
    }

    @Override
    public void updateLifecyleOnChangeContent(Node node, String siteName, String remoteUser) throws Exception {
        this.updateLifecyleOnChangeContent(node, siteName, remoteUser, null);
    }

    @Override
    public void updateLifecyleOnChangeContent(Node node, String siteName, String remoteUser, String newState) throws Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            this.enrollNodeInLifecycle(node, siteName, remoteUser);
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(node);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        boolean hasState = false;
        if (newState != null) {
            String[] states;
            for (String state : states = publicationPlugin.getPossibleStates()) {
                if (!state.equals(newState)) continue;
                hasState = true;
            }
        }
        if (hasState) {
            publicationPlugin.updateLifecyleOnChangeContent(node, remoteUser, newState);
        } else {
            publicationPlugin.updateLifecyleOnChangeContent(node, remoteUser);
        }
        this.listenerService.broadcast("WCMPublicationService.event.updateState", (Object)this.cmsService, (Object)node);
    }

    @Override
    public String getContentState(Node node) throws Exception {
        String currentState;
        block3: {
            currentState = null;
            try {
                if (node.hasProperty("publication:currentState")) {
                    currentState = node.getProperty("publication:currentState").getString();
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)("Error when perform getContentState: " + e.getMessage()));
            }
        }
        return currentState;
    }
}

