/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.viewer;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class)
public class UIContentViewer
extends UIBaseNodePresentation {
    public static final String TEMPLATE_NOT_SUPPORT = "UIContentViewer.msg.template-not-support";
    private NodeLocation originalNodeLocation;
    private NodeLocation viewNodeLocation;

    public Node getOriginalNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.originalNodeLocation);
    }

    public void setOriginalNode(Node originalNode) throws Exception {
        this.originalNodeLocation = NodeLocation.make((Node)originalNode);
    }

    public Node getNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.viewNodeLocation);
    }

    public void setNode(Node viewNode) {
        this.viewNodeLocation = NodeLocation.make((Node)viewNode);
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            String nodeType = this.getOriginalNode().getPrimaryNodeType().getName();
            if (templateService.isManagedNodeType(nodeType)) {
                return templateService.getTemplatePathByUser(false, nodeType, userName);
            }
        }
        catch (PathNotFoundException e) {
            Utils.createPopupMessage((UIContainer)this, TEMPLATE_NOT_SUPPORT, null, 0);
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, TEMPLATE_NOT_SUPPORT, null, 0);
        }
        return null;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
            return new JCRResourceResolver(workspace);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRepositoryName() {
        try {
            return this.getRepository();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getTemplatePath() {
        return null;
    }

    public String getNodeType() {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public UIComponent getCommentComponent() {
        return null;
    }

    public UIComponent getRemoveAttach() {
        return null;
    }

    public UIComponent getRemoveComment() {
        return null;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent(mimeType, (UIContainer)this);
    }
}

