/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.web.controller.regexp.GroupType;
import org.exoplatform.web.controller.regexp.Kind;
import org.exoplatform.web.controller.regexp.Lexer;
import org.exoplatform.web.controller.regexp.Quantifier;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.SyntaxException;

public class REParser {
    private final Lexer lexer;
    private static final Pattern QUANTIFIER_PATTERN = Pattern.compile("^(\\?|\\+|\\*)|\\{([0-9]+)(?:(,)([0-9]*))?\\}$");

    public REParser(CharSequence seq) {
        this.lexer = new Lexer(seq);
    }

    public REParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public void reset() {
        this.lexer.reset();
    }

    public int getIndex() {
        return this.lexer.getIndex();
    }

    public RENode parse() throws SyntaxException {
        return this.parseDisjunction();
    }

    public boolean isDone() {
        return this.lexer.isDone();
    }

    public RENode.Disjunction parseDisjunction() throws SyntaxException {
        RENode.Alternative alternative = this.parseAlternative();
        if (alternative != null) {
            if (this.lexer.next(Kind.OR)) {
                RENode.Disjunction next = this.parseDisjunction();
                return new RENode.Disjunction(alternative, next);
            }
            return new RENode.Disjunction(alternative);
        }
        if (this.lexer.next(Kind.OR)) {
            RENode.Disjunction next = this.parseDisjunction();
            return new RENode.Disjunction(null, next);
        }
        return null;
    }

    public RENode.Alternative parseAlternative() throws SyntaxException {
        RENode.Expr expr = this.parseExpression();
        if (expr != null) {
            RENode.Alternative next = this.parseAlternative();
            return new RENode.Alternative(expr, next);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RENode.Expr parseExpression() throws SyntaxException {
        Quantifier quantifier;
        void var1_5;
        if (this.lexer.next(Kind.BEGIN)) {
            RENode.Assertion.Begin begin = new RENode.Assertion.Begin();
        } else if (this.lexer.next(Kind.END)) {
            RENode.Assertion.End end = new RENode.Assertion.End();
        } else if (this.lexer.next(Kind.GROUP_OPEN)) {
            GroupType groupType = GroupType.forPrefix(this.lexer.getToken());
            RENode.Disjunction group = this.parseDisjunction();
            if (!this.lexer.next(Kind.GROUP_CLOSE)) throw new SyntaxException("Group not closed ");
            RENode.Group group2 = new RENode.Group(group, groupType);
        } else {
            RENode.Atom atom = this.parseCharacter();
        }
        if (var1_5 == null || (quantifier = this.parseQuantifier()) == null) return var1_5;
        var1_5.setQuantifier(quantifier);
        return var1_5;
    }

    public Quantifier parseQuantifier() throws SyntaxException {
        block10: {
            Quantifier.Mode mode;
            Quantifier.Range range;
            block14: {
                block13: {
                    block12: {
                        Matcher matcher;
                        block11: {
                            if (!this.lexer.next(Kind.QUANTIFIER)) break block10;
                            String quantifierToken = this.lexer.getToken();
                            matcher = QUANTIFIER_PATTERN.matcher(quantifierToken);
                            if (!matcher.matches()) {
                                throw new AssertionError((Object)("The quantifier token " + quantifierToken + " is not valid"));
                            }
                            if (matcher.group(1) == null) break block11;
                            switch (quantifierToken.charAt(0)) {
                                case '*': {
                                    range = Quantifier.Range.zeroOrMore();
                                    break block12;
                                }
                                case '+': {
                                    range = Quantifier.Range.oneOrMore();
                                    break block12;
                                }
                                case '?': {
                                    range = Quantifier.Range.onceOrNotAtAll();
                                    break block12;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        int min = Integer.parseInt(matcher.group(2));
                        Integer max = matcher.group(3) != null ? (matcher.group(4).isEmpty() ? null : Integer.valueOf(Integer.parseInt(matcher.group(4)))) : Integer.valueOf(min);
                        range = new Quantifier.Range(min, max);
                    }
                    if (!this.lexer.next(Kind.QUANTIFIER_MODE)) break block13;
                    switch (this.lexer.getToken().charAt(0)) {
                        case '?': {
                            mode = Quantifier.Mode.RELUCTANT;
                            break block14;
                        }
                        case '+': {
                            mode = Quantifier.Mode.POSSESSIVE;
                            break block14;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                mode = Quantifier.Mode.GREEDY;
            }
            return new Quantifier(mode, range);
        }
        return null;
    }

    public RENode.Atom parseCharacter() throws SyntaxException {
        if (this.lexer.next(Kind.ANY)) {
            return new RENode.Any();
        }
        RENode.Atom atom = this.parseCharacterLiteral();
        if (atom == null) {
            atom = this.parseCharacterClass();
        }
        return atom;
    }

    public RENode.Char parseCharacterLiteral() throws SyntaxException {
        if (this.lexer.next(Kind.LITERAL)) {
            return new RENode.Char(this.lexer.getToken().charAt(0));
        }
        return null;
    }

    public RENode.CharacterClass parseCharacterClass() throws SyntaxException {
        RENode.CharacterClassExpr cce = this._parseCharacterClass();
        if (cce != null) {
            return new RENode.CharacterClass(cce);
        }
        return null;
    }

    private RENode.CharacterClassExpr _parseCharacterClass() throws SyntaxException {
        if (this.lexer.next(Kind.CC_OPEN)) {
            boolean negated = this.lexer.getToken().length() > 1;
            RENode.CharacterClassExpr expr = this.parseCharacterClassExpression();
            if (expr != null) {
                if (this.lexer.next(Kind.CC_CLOSE)) {
                    return negated ? new RENode.CharacterClassExpr.Not(expr) : expr;
                }
                throw new SyntaxException("");
            }
            throw new SyntaxException("");
        }
        return null;
    }

    public RENode.CharacterClassExpr parseCharacterClassExpression() throws SyntaxException {
        RENode.CharacterClassExpr left = this.parseCharacterClassTerm();
        if (left != null) {
            boolean and = this.lexer.next(Kind.CC_AND);
            RENode.CharacterClassExpr right = this.parseCharacterClassExpression();
            if (right != null) {
                if (and) {
                    return new RENode.CharacterClassExpr.And(left, right);
                }
                return new RENode.CharacterClassExpr.Or(left, right);
            }
            return left;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RENode.CharacterClassExpr parseCharacterClassTerm() throws SyntaxException {
        RENode.CharacterClassExpr expr = this._parseCharacterClass();
        if (expr != null) return expr;
        RENode.CharacterClassExpr.Char c = this.parseCharacterClassLiteral();
        if (c != null) {
            if (!this.lexer.next(Kind.HYPHEN)) return c;
            RENode.CharacterClassExpr.Char to = this.parseCharacterClassLiteral();
            if (to == null) throw new SyntaxException();
            return new RENode.CharacterClassExpr.Range(c, to);
        }
        if (this.lexer.next(Kind.ANY)) {
            return new RENode.CharacterClassExpr.Char('.');
        }
        if (this.lexer.next(Kind.BEGIN)) {
            return new RENode.CharacterClassExpr.Char('^');
        }
        if (!this.lexer.next(Kind.END)) return expr;
        return new RENode.CharacterClassExpr.Char('$');
    }

    public RENode.CharacterClassExpr.Char parseCharacterClassLiteral() throws SyntaxException {
        if (this.lexer.next(Kind.LITERAL)) {
            return new RENode.CharacterClassExpr.Char(this.lexer.getToken().charAt(0));
        }
        return null;
    }
}

