/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class LDAPUserPageList
extends PageList {
    private String searchBase;
    private String filter;
    private LDAPService ldapService;
    private LDAPAttributeMapping ldapAttrMapping;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.LDAPUserPageList");
    static boolean SEARCH_CONTROL = false;

    public LDAPUserPageList(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, String searchBase, String filter, int pageSize) throws Exception {
        super(pageSize);
        this.ldapAttrMapping = ldapAttrMapping;
        this.ldapService = ldapService;
        this.searchBase = searchBase;
        this.filter = filter;
        try {
            int size = this.getResultSize();
            this.setAvailablePage(size);
        }
        catch (NameNotFoundException e) {
            LOG.warn((Object)"Cannot set the page size while creating a LDAPUserPageList, no page size will be used", (Throwable)e);
            this.setAvailablePage(0);
        }
        catch (OperationNotSupportedException e) {
            LOG.warn((Object)"Cannot set the page size while creating a LDAPUserPageList, no page size will be used", (Throwable)e);
            this.setAvailablePage(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateCurrentPage(int page) throws Exception {
        ArrayList<User> users = new ArrayList<User>();
        PagedResultsControl prc = new PagedResultsControl(this.getPageSize(), false);
        String[] keys = new String[]{this.ldapAttrMapping.userUsernameAttr};
        SortControl sctl = new SortControl(keys, SEARCH_CONTROL);
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                block16: {
                    users.clear();
                    try {
                        ctx.setRequestControls(new Control[]{sctl, prc});
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(2);
                        byte[] cookie = null;
                        int counter = 0;
                        do {
                            ++counter;
                            results = ctx.search(this.searchBase, this.filter, constraints);
                            while (results != null && results.hasMore()) {
                                SearchResult result = results.next();
                                if (counter != page) continue;
                                users.add(this.ldapAttrMapping.attributesToUser(result.getAttributes()));
                            }
                            Control[] responseControls = ctx.getResponseControls();
                            if (responseControls != null) {
                                for (int z = 0; z < responseControls.length; ++z) {
                                    if (!(responseControls[z] instanceof PagedResultsResponseControl)) continue;
                                    cookie = ((PagedResultsResponseControl)responseControls[z]).getCookie();
                                }
                            }
                            ctx.setRequestControls(new Control[]{new PagedResultsControl(this.getPageSize(), cookie, true)});
                        } while (cookie != null);
                        this.currentListPage_ = users;
                        if (results == null) break block16;
                    }
                    catch (NamingException e) {
                        block17: {
                            try {
                                if (BaseDAO.isConnectionError(e) && err < BaseDAO.getMaxConnectionError()) {
                                    this.ldapService.release(ctx);
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block17;
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    private int getResultSize() throws Exception {
        return this.getAll().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAll() throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        ArrayList<User> users = new ArrayList<User>();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<User> arrayList;
                block13: {
                    users.clear();
                    try {
                        SearchControls constraints = new SearchControls();
                        String[] returnedAtts = new String[]{this.ldapAttrMapping.userUsernameAttr};
                        constraints.setReturningAttributes(returnedAtts);
                        constraints.setSearchScope(2);
                        results = ctx.search(this.searchBase, this.filter, constraints);
                        while (results != null && results.hasMore()) {
                            SearchResult result = results.next();
                            users.add(this.ldapAttrMapping.attributesToUser(result.getAttributes()));
                        }
                        arrayList = users;
                        if (results == null) break block13;
                    }
                    catch (NamingException e) {
                        block14: {
                            try {
                                if (BaseDAO.isConnectionError(e) && err < 1) {
                                    this.ldapService.release(ctx);
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block14;
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }
}

