/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.ldap.BaseDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LdapListAccess<E>
implements ListAccess<E> {
    protected LDAPService ldapService;

    public LdapListAccess(LDAPService ldapService) {
        this.ldapService = ldapService;
    }

    public int getSize() throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    int n = this.getSize(ctx);
                    return n;
                }
                catch (NamingException e) {
                    block9: {
                        if (BaseDAO.isConnectionError(e) && err < BaseDAO.getMaxConnectionError()) {
                            this.ldapService.release(ctx);
                            ctx = this.ldapService.getLdapContext(true);
                            break block9;
                        }
                        int n = 0;
                        this.ldapService.release(ctx);
                        return n;
                    }
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public E[] load(int index, int length) throws Exception, IllegalArgumentException {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    E[] EArray = this.load(ctx, index, length);
                    return EArray;
                }
                catch (NamingException e) {
                    if (!BaseDAO.isConnectionError(e) || err >= BaseDAO.getMaxConnectionError()) {
                        throw e;
                    }
                    this.ldapService.release(ctx);
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    protected abstract E[] load(LdapContext var1, int var2, int var3) throws Exception;

    protected abstract int getSize(LdapContext var1) throws Exception;
}

