/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.config;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.config.ConfigContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ShindigAuthConfigContributor
implements ConfigContributor {
    private SecurityTokenCodec securityTokenCodec;

    @Inject
    public ShindigAuthConfigContributor(SecurityTokenCodec codec) {
        this.securityTokenCodec = codec;
    }

    @Override
    public void contribute(Map<String, Object> config, Gadget gadget) {
        GadgetContext context = gadget.getContext();
        SecurityToken authToken = context.getToken();
        if (authToken != null) {
            String trustedJson;
            HashMap authConfig = Maps.newHashMapWithExpectedSize((int)2);
            String updatedToken = authToken.getUpdatedToken();
            if (updatedToken != null) {
                authConfig.put("authToken", updatedToken);
            }
            if ((trustedJson = authToken.getTrustedJson()) != null) {
                authConfig.put("trustedJson", trustedJson);
            }
            config.put("shindig.auth", authConfig);
        }
    }

    @Override
    public void contribute(Map<String, Object> config, String container, String host) {
        AnonymousSecurityToken containerToken = new AnonymousSecurityToken(container, 0L, "*", Long.valueOf(86400000L));
        HashMap authConfig = Maps.newHashMapWithExpectedSize((int)2);
        try {
            config.put("shindig.auth", authConfig);
            authConfig.put("authToken", this.securityTokenCodec.encodeToken((SecurityToken)containerToken));
        }
        catch (SecurityTokenException e) {
            // empty catch block
        }
    }
}

