/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils.secure;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureList<E>
implements List<E> {
    private final List<E> list;
    private final Permission permission;

    public SecureList(Permission permission) {
        this.list = new ArrayList();
        this.permission = permission;
    }

    public SecureList(List<E> list, Permission permission) {
        this.list = list;
        this.permission = permission;
    }

    @Override
    public void add(int index, E pd) {
        this.checkPermissions();
        this.list.add(index, pd);
    }

    @Override
    public boolean add(E pd) {
        this.checkPermissions();
        return this.list.add(pd);
    }

    @Override
    public boolean addAll(Collection<? extends E> pds) {
        this.checkPermissions();
        return this.list.addAll(pds);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> pds) {
        this.checkPermissions();
        return this.list.addAll(index, pds);
    }

    @Override
    public void clear() {
        this.checkPermissions();
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || ((Object)this.list).equals(o);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<? extends E> i;
            {
                this.i = SecureList.this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                SecureList.this.checkPermissions();
                this.i.remove();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            ListIterator<E> li;
            {
                this.li = SecureList.this.list.listIterator(index);
            }

            @Override
            public void add(E pd) {
                SecureList.this.checkPermissions();
                this.li.add(pd);
            }

            @Override
            public boolean hasNext() {
                return this.li.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.li.hasPrevious();
            }

            @Override
            public E next() {
                return this.li.next();
            }

            @Override
            public int nextIndex() {
                return this.li.nextIndex();
            }

            @Override
            public E previous() {
                return this.li.previous();
            }

            @Override
            public int previousIndex() {
                return this.li.previousIndex();
            }

            @Override
            public void remove() {
                SecureList.this.checkPermissions();
                this.li.remove();
            }

            @Override
            public void set(E pd) {
                SecureList.this.checkPermissions();
                this.li.set(pd);
            }
        };
    }

    @Override
    public E remove(int index) {
        this.checkPermissions();
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.checkPermissions();
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> pds) {
        this.checkPermissions();
        return this.list.removeAll(pds);
    }

    @Override
    public boolean retainAll(Collection<?> pds) {
        this.checkPermissions();
        return this.list.retainAll(pds);
    }

    @Override
    public E set(int index, E pd) {
        this.checkPermissions();
        return this.list.set(index, pd);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SecureList<E>(this.list.subList(fromIndex, toIndex), this.permission);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }

    private void checkPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.permission);
        }
    }
}

