/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.staticdirect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.http.HttpSession;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:resources/templates/staticdirect/UIPublicationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UnsubcriberLifeCycleActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIPublicationForm
extends UIForm {
    public static final String VISIBILITY = "visibility";
    public static final String STATE = "state";
    private VersionNode curentVersion_;
    private VersionNode rootVersion_;
    private NodeLocation currentNode_;
    private String visibility_;
    private String state_;

    public void updateForm(VersionNode versionNode) throws Exception {
        String state = this.getStateByVersion(versionNode);
        this.resetCurrentState(state, this.visibility_);
    }

    public void resetCurrentState(String state, String visibility) throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String published = res.getString("UIPublicationForm.label.published");
        String non_published = res.getString("UIPublicationForm.label.non-published");
        String lblPublic = res.getString("UIPublicationForm.label.public");
        String lblPrivate = res.getString("UIPublicationForm.label.private");
        this.removeChildById(VISIBILITY);
        this.removeChildById(STATE);
        ArrayList<SelectItemOption> visibilityOptions = new ArrayList<SelectItemOption>();
        visibilityOptions.add(new SelectItemOption(lblPublic, (Object)"public"));
        visibilityOptions.add(new SelectItemOption(lblPrivate, (Object)"private"));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(VISIBILITY, visibility, visibilityOptions).setAlign(UIFormRadioBoxInput.HORIZONTAL_ALIGN));
        ArrayList<SelectItemOption> stateOptions = new ArrayList<SelectItemOption>();
        stateOptions.add(new SelectItemOption(published, (Object)"published"));
        stateOptions.add(new SelectItemOption(non_published, (Object)"non published"));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(STATE, state, stateOptions).setAlign(UIFormRadioBoxInput.HORIZONTAL_ALIGN));
    }

    public String getStateByVersion(VersionNode versionNode) throws Exception {
        Value[] publicationStates;
        for (Value value : publicationStates = this.getRealCurrentNode().getProperty("publication:versionsPublicationStates").getValues()) {
            String[] arrPublicationState = value.getString().split(",");
            for (int i = 0; i < arrPublicationState.length; ++i) {
                if (!arrPublicationState[0].equals(versionNode.getUUID())) continue;
                return arrPublicationState[1];
            }
        }
        return "non published";
    }

    public void initForm(Node currentNode) throws Exception {
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)currentNode);
        this.rootVersion_ = new VersionNode(currentNode.getVersionHistory().getRootVersion());
        this.curentVersion_ = new VersionNode(currentNode.getBaseVersion());
        this.visibility_ = currentNode.getProperty("publication:visibility").getString();
        this.state_ = this.getStateByVersion(this.curentVersion_);
        this.resetCurrentState(this.state_, this.visibility_);
    }

    public void setVersionNode(VersionNode versionNode) {
        this.curentVersion_ = versionNode;
    }

    public static String getLockToken(Node node) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        String key = UIPublicationForm.createLockKey(node);
        Map lockedNodesInfo = (Map)httpSession.getAttribute(LockManagerImpl.class.getName());
        if (lockedNodesInfo == null) {
            return null;
        }
        return (String)lockedNodesInfo.get(key);
    }

    public static String createLockKey(Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(session.getUserID()).append(":/:").append(node.getPath());
        return buffer.toString();
    }

    private Node getRealCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIPublicationForm> {
        public void execute(Event<UIPublicationForm> event) throws Exception {
            UIPublicationForm uiForm = (UIPublicationForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnsubcriberLifeCycleActionListener
    extends EventListener<UIPublicationForm> {
        public void execute(Event<UIPublicationForm> event) throws Exception {
            UIPublicationForm uiPublicationForm = (UIPublicationForm)((Object)event.getSource());
            Node selectedNode = uiPublicationForm.getRealCurrentNode();
            UIApplication uiApp = (UIApplication)uiPublicationForm.getAncestorOfType(UIApplication.class);
            if (!selectedNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            PublicationService publicationService = (PublicationService)uiPublicationForm.getApplicationComponent(PublicationService.class);
            if (publicationService.isUnsubcribeLifecycle(selectedNode)) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.unsubcriber-lifecycle", null, 1));
                return;
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiPublicationForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            publicationService.unsubcribeLifecycle(selectedNode);
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.unsubcriber-lifecycle-finish", null));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPublicationForm> {
        public void execute(Event<UIPublicationForm> event) throws Exception {
            String lockToken;
            UIPublicationForm uiForm = (UIPublicationForm)((Object)event.getSource());
            String visibility = (String)((UIFormRadioBoxInput)uiForm.getUIInput(UIPublicationForm.VISIBILITY)).getValue();
            String state = (String)((UIFormRadioBoxInput)uiForm.getUIInput(UIPublicationForm.STATE)).getValue();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (uiForm.getRealCurrentNode().isLocked() && (lockToken = UIPublicationForm.getLockToken(uiForm.getRealCurrentNode())) != null) {
                uiForm.getRealCurrentNode().getSession().addLockToken(lockToken);
            }
            if (!uiForm.getRealCurrentNode().isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            PublicationService publicationService = (PublicationService)uiForm.getApplicationComponent(PublicationService.class);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("nodeVersionUUID", uiForm.curentVersion_.getUUID());
            context.put(UIPublicationForm.VISIBILITY, visibility);
            publicationService.changeState(uiForm.getRealCurrentNode(), state, context);
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }
}

