/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.apache.shindig.common.servlet.GuiceServletContextListener;

public abstract class InjectedServlet
extends HttpServlet {
    protected Injector injector;
    protected transient boolean initialized = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        this.injector = (Injector)context.getAttribute("guice-injector");
        if (this.injector == null) {
            this.injector = (Injector)context.getAttribute(GuiceServletContextListener.INJECTOR_NAME);
            if (this.injector == null) {
                throw new UnavailableException("Guice Injector not found! Make sure you registered " + GuiceServletContextListener.class.getName() + " as a listener");
            }
        }
        this.injector.injectMembers((Object)this);
        this.initialized = true;
    }

    protected void checkInitialized() {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Servlet already initialized");
    }
}

