/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.SymbolTable;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.util.Lists;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LexicalScope {
    final AncestorChain<?> root;
    final LexicalScope parent;
    final SymbolTable symbols;
    final List<LexicalScope> innerScopes = Lists.newArrayList();

    LexicalScope(AncestorChain<?> root, LexicalScope parent) {
        this.root = root;
        this.parent = parent;
        this.symbols = new SymbolTable();
        if (parent != null) {
            parent.innerScopes.add(this);
        }
    }

    LexicalScope declaringScope(String symbolName) {
        if (this.symbols.getSymbol(symbolName) != null) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.declaringScope(symbolName);
    }

    boolean inSameProgramUnit(LexicalScope that) {
        LexicalScope shallow;
        LexicalScope deep;
        if (this.root.depth >= that.root.depth) {
            deep = this;
            shallow = that;
        } else {
            deep = that;
            shallow = this;
        }
        while (shallow.parent != null && !shallow.isFunctionScope()) {
            shallow = shallow.parent;
        }
        LexicalScope s = deep;
        while (s != null) {
            if (s == shallow) {
                return true;
            }
            if (s.isFunctionScope()) {
                return false;
            }
            s = s.parent;
        }
        return false;
    }

    boolean isWithScope() {
        return this.root.node instanceof WithStmt;
    }

    boolean isCatchScope() {
        return this.root.node instanceof CatchStmt;
    }

    boolean isFunctionScope() {
        return this.root.node instanceof FunctionConstructor;
    }

    boolean isGlobal() {
        return this.parent == null;
    }
}

