/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.EnvironmentDatum;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Parser;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Maps;
import java.io.PrintWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentData {
    private final Map<String, Object> data = Maps.newLinkedHashMap();
    static final MessageQueue LOUD_MQ = new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext(), true);

    public EnvironmentData(Map<? extends String, ?> data) throws ParseException {
        for (Map.Entry<String, ?> e : data.entrySet()) {
            this.data.put(EnvironmentData.normJsQuiet(e.getKey()), e.getValue());
        }
    }

    public Object get(String code) throws IllegalArgumentException {
        try {
            return this.data.get(EnvironmentData.normJsQuiet(code));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad code snippet " + code, ex);
        }
    }

    public Object get(EnvironmentDatum d) {
        return this.data.get(d.getCode());
    }

    public static String normJsQuiet(String js) throws ParseException {
        return EnvironmentData.normJs(js, DevNullMessageQueue.singleton());
    }

    static String normJs(String js, MessageQueue mq) throws ParseException {
        JsLexer lexer = new JsLexer(CharProducer.Factory.fromString((CharSequence)js, FilePosition.UNKNOWN));
        JsTokenQueue tq = new JsTokenQueue(lexer, InputSource.UNKNOWN);
        Expression e = new Parser(tq, mq).parseExpression(true);
        tq.expectEmpty();
        StringBuilder sb = new StringBuilder(js.length() + 16);
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(sb)));
        e.render(rc);
        rc.getOut().noMoreTokens();
        return sb.toString();
    }
}

