/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.config;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConfigMessageType implements MessageTypeInt
{
    MALFORMED_CONFIG("%s: malformed config file: expected %s, not %s", MessageLevel.FATAL_ERROR),
    BAD_URL("%s: malformed URI: %s = %s", MessageLevel.FATAL_ERROR),
    AMBIGUOUS_DEFINITION("%s: ambiguous type definition %s != %s", MessageLevel.FATAL_ERROR),
    UNRECOGNIZED_KEY("%s: unrecognized key %s", MessageLevel.WARNING);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private ConfigMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }
}

