/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.DecodingCharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.util.CajaTestCase;
import java.io.StringReader;
import java.util.Arrays;

public class DecodingCharProducerTest
extends CajaTestCase {
    private DecodingCharProducer p;

    public void setUp() throws Exception {
        super.setUp();
        this.p = DecodingCharProducer.make(new DecodingCharProducer.Decoder(){

            void decode(char[] chars, int offset, int limit) {
                int end;
                if (chars[offset] != '\\') {
                    this.codePoint = chars[offset];
                } else {
                    for (end = offset + 1; end < limit && chars[end] == '.'; ++end) {
                    }
                    int count = end - offset - 1;
                    this.codePoint = (char)Math.min(48 + count, 57);
                }
                this.end = end;
            }
        }, CharProducer.Factory.create(new StringReader("foo\\...bar\\..baz\\.boo\\far"), FilePosition.instance(this.is, 1, 101, 101)));
    }

    public final void testDecoding() {
        DecodingCharProducerTest.assertEquals((String)"foo3bar2baz1boo0far", (String)String.valueOf(this.p.getBuffer(), this.p.getOffset(), this.p.getLimit() - this.p.getOffset()));
    }

    public final void testCharInFile() {
        int[] charsInFile = new int[this.p.getLimit() - this.p.getOffset() + 1];
        for (int i = 0; i < charsInFile.length; ++i) {
            charsInFile[i] = this.p.getCharInFile(this.p.getOffset() + i);
        }
        DecodingCharProducerTest.assertEquals((String)"[101, 102, 103, 104, 108, 109, 110, 111, 114, 115, 116, 117, 119, 120, 121, 122, 123, 124, 125, 126]", (String)Arrays.toString(charsInFile));
    }

    public final void testUnderlyingOffsets() {
        int[] underlyingOffsets = new int[this.p.getLimit() - this.p.getOffset() + 1];
        for (int i = 0; i < underlyingOffsets.length; ++i) {
            underlyingOffsets[i] = this.p.getUnderlyingOffset(this.p.getOffset() + i);
        }
        DecodingCharProducerTest.assertEquals((String)"[0, 1, 2, 3, 7, 8, 9, 10, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25]", (String)Arrays.toString(underlyingOffsets));
    }
}

