/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.quasiliteral.AlphaRenamingRewriter;
import com.google.caja.parser.quasiliteral.NameContext;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlphaRenaming {
    public static Expression rename(Expression e, NameContext<String, ?> renamableExterns, Set<String> fixedExterns, MessageQueue mq) {
        Expression f = (Expression)new AlphaRenamingRewriter(mq, renamableExterns).expand(e);
        Map<String, FormalParam> rewrittenNames = Maps.newLinkedHashMap();
        for (NameContext<String, ?> p = renamableExterns; p != null; p = p.getParentContext()) {
            for (NameContext.VarInfo<String, ?> ni : p.vars()) {
                String rewrittenName = ni.newName;
                rewrittenNames.put(rewrittenName, new FormalParam(new Identifier(ni.declaredAt, rewrittenName)));
            }
        }
        for (String fixedExtern : fixedExterns) {
            rewrittenNames.put(fixedExtern, new FormalParam(new Identifier(FilePosition.UNKNOWN, fixedExtern)));
        }
        Block program = (Block)QuasiBuilder.substV("{ (function (@formals*) { @f; }); }", "formals", new ParseTreeNodeContainer(Lists.newArrayList(rewrittenNames.values())), "f", new ExpressionStmt(f));
        MessageQueue sanityCheckMq = DevNullMessageQueue.singleton();
        Set<String> freeIdents = Sets.newLinkedHashSet();
        Scope programScope = Scope.fromProgram(program, sanityCheckMq);
        AlphaRenaming.checkScope(program, programScope, freeIdents);
        if (!freeIdents.isEmpty()) {
            List<MessagePart> freeVarParts = Lists.newArrayList();
            for (String freeIdent : freeIdents) {
                freeVarParts.add(MessagePart.Factory.valueOf(freeIdent));
            }
            mq.addMessage((MessageTypeInt)RewriterMessageType.ALPHA_RENAMING_FAILURE, e.getFilePosition(), MessagePart.Factory.valueOf(freeVarParts));
            mq.getMessages().addAll(sanityCheckMq.getMessages());
            return new NullLiteral(e.getFilePosition());
        }
        return f;
    }

    private static void checkScope(ParseTreeNode n, Scope s, Set<String> outers) {
        Scope childScope = s;
        if (n instanceof FunctionConstructor) {
            childScope = Scope.fromFunctionConstructor(s, (FunctionConstructor)n);
        } else if (n instanceof CatchStmt) {
            childScope = Scope.fromCatchStmt(s, (CatchStmt)n);
        } else if (n instanceof Reference) {
            String name = ((Reference)n).getIdentifierName();
            if (AlphaRenaming.isOuter(name, s)) {
                outers.add(name);
            }
        } else if (Operation.is(n, Operator.MEMBER_ACCESS)) {
            Operation op = (Operation)n;
            AlphaRenaming.checkScope(op.children().get(0), s, outers);
            return;
        }
        for (ParseTreeNode parseTreeNode : n.children()) {
            AlphaRenaming.checkScope(parseTreeNode, childScope, outers);
        }
    }

    private static boolean isOuter(String name, Scope s) {
        if ("this".equals(name) || "arguments".equals(name)) {
            return s.isOuter();
        }
        return s.isOuter(name);
    }

    private AlphaRenaming() {
    }
}

