/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.RewriterTestCase;
import com.google.caja.util.FailureIsAnOption;
import junit.framework.AssertionFailedError;

public abstract class CommonJsRewriterTestCase
extends RewriterTestCase {
    public final void testIn() throws Exception {
        this.assertConsistent("('length' in {}) && fail('readable property mistaken for existing property');");
        this.assertConsistent("('length' in []) || fail('arrays should have a length');");
        this.assertConsistent("('x' in { x: 1 }) || fail('failed to find existing readable property');");
        this.assertConsistent("('y' in { x: 1 }) && fail('found nonexisting property');");
        this.assertConsistent("var flag = true;try { 'length' in '123'; }catch (e) { flag = false; }if (flag) { fail ('should throw TypeError'); }true;");
    }

    public final void testArrayLikeApply() throws Exception {
        this.assertConsistent("function x(a,b) { return a===0 && b===1; }function y() { return x.apply(null,arguments); }x.apply(null, [0,1]);");
        this.assertConsistent("function x(a,b) { return a===0 && b===1; }function y() { return x.apply(null,arguments); }y.apply(null, [0,1]);");
    }

    public final void testStringLength() throws Exception {
        this.assertConsistent("('123').length;");
    }

    public final void testEval() throws Exception {
        this.rewriteAndExecute("var success = false;try { eval('1'); } catch (e) { success = true; }if (!success) { fail('Outer eval is accessible.'); }");
    }

    public final void testMutableArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  try {    if (arguments[0] !== false || arguments.length !== 1) {       fail('arguments not initialized correctly');    }    arguments[0] = true;  } catch (e) {    fail('assignment to arguments failed');  }  if (a) { fail('Joined arguments'); }  if (!arguments[0]) { fail('arguments not mutated'); }}f(false);");
    }

    public final void testGetArgsCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.caller; } catch (e) { return; }  fail('arguments.caller did not throw');}f();");
    }

    @FailureIsAnOption
    public final void testSetArgsCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.caller = 8; } catch (e) { return; }  fail('assigning to arguments.caller did not throw');}f();");
    }

    public final void testGetFuncCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { f.caller; } catch (e) { return; }  fail('<function>.caller did not throw');}f();");
    }

    @FailureIsAnOption
    public final void testSetFuncCaller() throws Exception {
        this.rewriteAndExecute("function f() {  try { f.caller = 9; } catch (e) { return; }  fail('assigning to <function>.caller did not throw');}f();");
    }

    public final void testGetArgsCallee() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.callee; } catch (e) { return; }  fail('arguments.callee did not throw');}f();");
    }

    @FailureIsAnOption
    public final void testSetArgsCallee() throws Exception {
        this.rewriteAndExecute("function f() {  try { arguments.callee = 7; } catch (e) { return; }  fail('assigning to arguments.callee did not throw');}f();");
    }

    public final void testGetFuncArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  g();}\nfunction g() {  try { f.arguments; } catch (e) { return; }  fail('<function>.arguments did not throw');}f(false);");
    }

    @FailureIsAnOption
    public final void testSetFuncArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  g();}\nfunction g() {  try { f.arguments = 6; } catch (e) { return; }  fail('assigning to <function>.arguments did not throw');}f(false);");
    }

    public final void testCrossScopeArguments() throws Exception {
        this.rewriteAndExecute("function f(a) {  g();  if (a) { fail('Mutable cross scope arguments'); }}\nfunction g() {  var args;  try { args = f.arguments; } catch (e) { return; }  if (args) { args[0] = true; }}f(false);");
    }

    public final void testSameArguments() throws Exception {
        this.assertConsistent("function foo() {  return arguments === arguments;}foo();");
    }

    public final void testConcatArguments() throws Exception {
        this.assertConsistent("function foo() {  return [1].concat(arguments);}foo('a', 'b')[1][1];");
    }

    public final void testCatch() throws Exception {
        try {
            this.rewriteAndExecute("var e = false;try { throw true; } catch (e) {}if (e) { fail('Exception visible out of proper scope'); }");
            CommonJsRewriterTestCase.fail((String)"Exception that masks var should not pass");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public final void testSetTimeout() throws Exception {
        this.rewriteAndExecute("var success=false;try { setTimeout('1',10); } catch(e) { success=true; }if (!success) { fail('setTimeout is accessible'); }");
    }

    public final void testObjectWatch() throws Exception {
        this.rewriteAndExecute("var x={}; var success=false;try { x.watch(y, function(){}); } catch(e) { success=true; }if (!success) { fail('Object.watch is accessible'); }");
    }

    public final void testForIn1() throws Exception {
        this.rewriteAndExecute("function Foo() {  return { x: 1, y: 2, z: 3 };}var obj = new Foo();var y = {};var result = [];for (y.k in obj) {  result.push(y.k);}assertEquals(    '' + result,    '' + ['x', 'y', 'z']);");
        this.rewriteAndExecute("function test(obj) {  var y = {};  var result = [];  for (y.k in obj) {    result.push(y.k);  }  return '' + result;}assertEquals('', test());");
        this.rewriteAndExecute("function Foo() {  return { x: 1, y: 2, z: 3 };}var obj = new Foo();var result = [];for (var k in obj)  result.push(k);assertEquals(    '' + result,    '' + ['x', 'y', 'z']);");
    }

    public final void testFor() throws Exception {
        this.assertConsistent("var i; for (i = 0; i < 10; i++) {} i;");
        this.assertConsistent("for (var i = 0; i < 10; i++) {} i;");
        this.assertConsistent("for (var i = 0, j = 0; i < 10; i++) { j += 10; } j;");
        this.assertConsistent("for (var i = 0, j = 0; i < 10; i++, j += 10) { } j;");
    }

    public final void testMultiDeclaration() throws Exception {
        this.assertConsistent("var a = 3, b = 4, c = 5; a + b + c;");
        this.assertConsistent("var a, b; a = 3; b = 4; a + b;");
        this.assertConsistent("  function f() {  var a = 3, b = 4;  return a + b; }f();");
    }

    public final void testCommonReformedGenerics() throws Exception {
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.call(x, 44);x;");
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.apply(x, [6,7,8]);x;");
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.bind(x)(6,7,8);x;");
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo.bind(x,6)(7,8);x;");
        this.assertConsistent("[].push.length;");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo.call(x, 44);delete x.foo;x;");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo.call(x, 44);cajita.getOwnPropertyNames(x).sort();");
    }

    public final void testTypeofConsistent() throws Exception {
        this.assertConsistent("[ (typeof noSuchGlobal), (typeof 's'),  (typeof 4),  (typeof null),  (typeof (void 0)),  (typeof []),  (typeof {}),  (typeof (function () {})),  (typeof { x: 4.0 }.x),  (typeof { 2: NaN }[1 + 1])];");
        this.rewriteAndExecute("assertEquals(typeof new RegExp('.*'), 'object');");
    }

    public final void testCommonCallback() throws Exception {
        this.assertConsistent("'abc'.replace('b', function() {return 'xy';});");
        this.assertConsistent("var v = [1, 2, 3, 7, 4, 5];var cmp = function(a, b) {  return (a < b) ? +1 : (b < a) ? -1 : 0;};v.sort(cmp);");
        this.rewriteAndExecute("", "var a = [];\ncajita.forOwnKeys({x:3}, function(k, v) {a.push(k, v);});assertEquals(a.toString(), 'x,3');", "var a = [];\ncajita.forOwnKeys({x:3}, ___.markFuncFreeze(function(k, v) {a.push(k, v);}));assertEquals(a.toString(), 'x,3');");
        this.rewriteAndExecute("", "var a = [];\ncajita.forAllKeys({x:3}, function(k, v) {a.push(k, v);});assertEquals(a.toString(), 'x,3');", "var a = [];\ncajita.forAllKeys({x:3}, ___.markFuncFreeze(function(k, v) {a.push(k, v);}));assertEquals(a.toString(), 'x,3');");
        this.assertConsistent("(function(){}).bind.call(function(a, b) {return a + b;}, {}, 3)(4);");
    }

    public final void testNoPrivilegeEscalation() throws Exception {
        this.rewriteAndExecute("", "assertTrue([].valueOf.call(null) === cajita.USELESS);", "assertTrue([].valueOf.call(null) === this);");
        this.rewriteAndExecute("", "assertTrue([].valueOf.apply(null, []) === cajita.USELESS);", "assertTrue([].valueOf.apply(null, []) === this);");
        this.rewriteAndExecute("", "assertTrue([].valueOf.bind(null)() === cajita.USELESS);", "assertTrue([].valueOf.bind(null)() === this);");
    }

    public final void testTamedXo4aOkOnNull() throws Exception {
        this.rewriteAndExecute("this.foo = 8;", "var x = cajita.beget(cajita.USELESS);assertFalse(({foo: 7}).hasOwnProperty.call(null, 'foo'));assertTrue(cajita.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.call(null, x));", "assertTrue(({}).hasOwnProperty.call(null, 'foo'));assertFalse(({bar: 7}).hasOwnProperty.call(null, 'bar'));");
        this.rewriteAndExecute("this.foo = 8;", "var x = cajita.beget(cajita.USELESS);assertFalse(({foo: 7}).hasOwnProperty.apply(null, ['foo']));assertTrue(cajita.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.apply(null, [x]));", "assertTrue(({}).hasOwnProperty.apply(null, ['foo']));assertFalse(({bar: 7}).hasOwnProperty.apply(null, ['bar']));");
        this.rewriteAndExecute("this.foo = 8;", "var x = cajita.beget(cajita.USELESS);assertFalse(({foo: 7}).hasOwnProperty.bind(null)('foo'));assertTrue(cajita.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.bind(null)(x));", "assertTrue(({}).hasOwnProperty.bind(null)('foo'));assertFalse(({bar: 7}).hasOwnProperty.bind(null)('bar'));");
    }

    public final void testErrorTaming() throws Exception {
        this.rewriteAndExecute("var t = new Error('foo');assertFalse(cajita.isFrozen(t));try {  throw t;} catch (ex) {  assertTrue(t === ex);}");
    }

    public final void testJSONClass() throws Exception {
        this.rewriteAndExecute("assertTrue(({}).toString.call(JSON) === '[object JSON]');");
        this.rewriteAndExecute("assertTrue(JSON.toString() === '[object JSON]');");
        this.rewriteAndExecute("assertTrue(''+JSON === '[object Object]');");
    }

    public final void testNoCanSetInheritance() throws Exception {
        this.rewriteAndExecute("(function() {  var a = {};  var b = cajita.freeze(cajita.beget(a));  a.x = 8;  assertThrows(function(){b.x = 9;});  assertEquals(b.x, 8);})();");
    }

    public final void testFeralTameBoundary() throws Exception {
        this.rewriteAndExecute("function forbidden() { return arguments; }function xo4ic(f) {  return ___.callPub(f, 'call', [___.USELESS, this]);}___.markXo4a(xo4ic);function innocent(f) { return f(this); }___.markInnocent(innocent);function simple(f) {  return ___.callPub(f, 'call', [___.USELESS, simple]); }___.markFuncFreeze(simple);function Point(x,y) {  this.x = x;  this.y = y;}Point.prototype.getX = function() { return this.x; };Point.prototype.getY = function() { return this.y; };Point.prototype.badness = function(str) { return eval(str); };Point.prototype.welcome = function(visitor) {  return visitor(this.x, this.y); };___.markCtor(Point, Object, 'Point');___.grantGenericMethod(Point.prototype, 'getX');___.grantTypedMethod(Point.prototype, 'getY');___.grantInnocentMethod(Point.prototype, 'welcome');var pt = new Point(3,5);function eight() { return 8; }function nine() { return 9; }___.markFuncFreeze(nine);___.tamesTo(eight, nine);var funcs = [[simple, Point, pt], forbidden,              xo4ic, innocent, eight];___.freeze(funcs[0]);funcs[5] = funcs;var f = {   forbidden: forbidden,  xo4ic: xo4ic,  innocent: innocent,  simple: simple,  Point: Point,  pt: pt,  eight: eight,  funcs: funcs};f.f = f;funcs[6] = f;testImports.f = f;testImports.t = ___.tame(f);", "assertFalse(f === t);assertFalse('forbidden' in t);assertFalse(f.xo4ic === t.xo4ic);assertFalse(f.innocent === t.innocent);assertTrue(f.simple === t.simple);assertTrue(f.Point === t.Point);assertTrue(f.pt === t.pt);assertFalse('x' in t.pt);assertFalse('y' in t.pt);assertTrue('getX' in t.pt);assertTrue('getY' in t.pt);assertFalse('badness' in t.pt);assertTrue('welcome' in t.pt);assertFalse(f.eight === t.eight);assertFalse(f.funcs === t.funcs);assertTrue(f.funcs[0][0] === t.funcs[0][0]);assertTrue(f.funcs[0] === t.funcs[0]);assertTrue('1' in t.funcs);assertTrue(t.funcs[1] === void 0);assertTrue(t.funcs === t.funcs[5]);assertTrue(t === t.funcs[6]);assertTrue(t === t.f);var lastArg = void 0;function capture(arg) { return lastArg = arg; }var lastResult = t.xo4ic.call(void 0, capture);assertTrue(lastArg === cajita.USELESS);assertTrue(lastResult === cajita.USELESS);lastResult = t.innocent.call(void 0, capture);assertTrue(lastArg === cajita.USELESS);assertTrue(lastResult === cajita.USELESS);lastResult = t.innocent.apply(void 0, [capture]);assertTrue(lastArg === cajita.USELESS);assertTrue(lastResult === cajita.USELESS);lastResult = t.simple(capture);assertTrue(lastArg === t.simple);assertTrue(lastResult === t.simple);assertTrue(t.pt.getX() === 3);assertTrue(t.pt.getY() === 5);var getX = t.pt.getX;var getY = t.pt.getY;assertTrue(cajita.isPseudoFunc(getX));assertTrue(cajita.isPseudoFunc(getY));assertTrue(getX.call(t.pt) === 3);assertTrue(getY.call(t.pt) === 5);var nonpt = {x: 33, y: 55};assertTrue(getX.call(nonpt) === 33);assertThrows(function() { getY.call(nonpt); });function visitor(x, y) {  assertTrue(x === 3);  assertTrue(y === 5);}t.pt.welcome(visitor);assertTrue(t.eight() === 9);lastResult = t.innocent.call(void 0, t.eight);assertTrue(lastResult === 8);lastResult = t.innocent.apply(void 0, [t.eight]);assertTrue(lastResult === 8);", "");
    }

    public final void testFunctionClass() throws Exception {
        this.rewriteAndExecute("assertTrue(({}).toString.call(function(){})==='[object Function]')");
    }
}

