/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RuleDoclet;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.util.Join;
import java.io.IOException;
import java.io.Writer;

public class DojoRuleDoclet
extends RuleDoclet {
    private StringBuilder dojoDocument;
    private StringBuilder table;
    private int countRules;

    public String getDefaultExtension() {
        return "js";
    }

    public void initialize(Writer output) {
        this.dojoDocument = new StringBuilder();
        this.dojoDocument.append("var data = ");
    }

    public void generateHeader(Writer output, RulesetDescription ruleSet) {
    }

    public void generateFooter(Writer output, RulesetDescription ruleSet) {
        this.dojoDocument.append(this.table.toString());
        this.dojoDocument.append("]");
    }

    public void finish(Writer output) throws IOException {
        output.write(this.dojoDocument.toString());
    }

    private String escape(String js) {
        StringBuilder result = new StringBuilder();
        Escaping.escapeJsString((CharSequence)js, false, false, result);
        return result.toString();
    }

    private String quote(String js) {
        return "'" + this.escape(js) + "'";
    }

    public void generateRuleDocumentation(Writer output, RuleDescription anno) {
        if (0 == this.countRules) {
            this.table = new StringBuilder();
            this.table.append("[");
        }
        this.table.append("[");
        this.table.append(Join.join((CharSequence)",", "" + this.countRules++, this.quote(anno.name()), this.quote(anno.synopsis()), this.quote(anno.matches()), this.quote(anno.substitutes()), this.quote(anno.reason())));
        this.table.append("],\n");
    }
}

