/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.parser.css.CssTree;
import com.google.caja.plugin.Candidate;
import com.google.caja.plugin.CssPropertyPartType;
import com.google.caja.plugin.Match;
import com.google.caja.plugin.MessageSList;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.Name;
import com.google.caja.util.Strings;
import com.google.caja.util.SyntheticAttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SignatureResolver {
    private static final boolean DEBUG = false;
    private Candidate best;
    private final CssTree.Expr expr;
    private final CssSchema cssSchema;
    private static final String REAL_NUMBER_RE = "(?:\\d+(?:\\.\\d+)?|\\.\\d+)";
    private static final Pattern LENGTH_RE = Pattern.compile("^(?:(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:in|cm|mm|pt|pc|em|ex|px)?)$", 2);
    private static final Pattern NUMBER_RE = Pattern.compile("^(?:\\d+(?:\\.\\d+)?|\\.\\d+)$");
    private static final Pattern INTEGER_RE = Pattern.compile("^\\d+$");
    private static final Pattern PERCENTAGE_RE = Pattern.compile("^(?:\\d+(?:\\.\\d+)?|\\.\\d+)%$");
    private static final Pattern SPECIFIC_VOICE_RE = Pattern.compile("^\\s*(?:[\\w\\-]+(?:\\s+[\\w\\-]+)*)\\s*$", 2);
    private static final Pattern ANGLE_RE = Pattern.compile("^(?:(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:deg|grad|rad)|0+)$", 2);
    private static final Pattern TIME_RE = Pattern.compile("^(?:(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:ms|s)|0+)$", 2);
    private static final Pattern FREQUENCY_RE = Pattern.compile("^(?:(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:hz|kHz)|0+)$", 2);
    private static final Pattern LENGTH_SUFFIX_RE = Pattern.compile("\\}(?:in|cm|mm|pt|pc|em|ex|px)?$", 2);
    private static final Pattern PERCENTAGE_SUFFIX_RE = Pattern.compile("\\}%$");
    private static final Pattern NUMBER_SUFFIX_RE;
    private static final Pattern COLOR_SUFFIX_RE;
    private static final Pattern ANGLE_SUFFIX_RE;
    private static final Pattern TIME_SUFFIX_RE;
    private static final Pattern FREQUENCY_SUFFIX_RE;
    private static final Pattern URI_SUFFIX_RE;
    private static final SyntheticAttributeKey<Integer> NUM;
    private static int serialno;

    SignatureResolver(CssTree.Expr expr, CssSchema cssSchema) {
        this.expr = expr;
        this.cssSchema = cssSchema;
    }

    Candidate getBestAttempt() {
        return this.best;
    }

    List<Candidate> applySignature(List<Candidate> candidates, Name propertyName, CssPropertySignature sig) {
        ArrayList<Candidate> passed = new ArrayList<Candidate>();
        for (Candidate candidate : candidates) {
            if (this.checkEnd(candidate, sig, passed)) continue;
            this.skipBlank(candidate);
            if (sig instanceof CssPropertySignature.SetSignature) {
                this.applySetSignature((CssPropertySignature.SetSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.SeriesSignature) {
                this.applySeriesSignature((CssPropertySignature.SeriesSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.RepeatedSignature) {
                this.applyRepeatedSignature((CssPropertySignature.RepeatedSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.LiteralSignature) {
                this.applyLiteralSignature((CssPropertySignature.LiteralSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.QuotedLiteralSignature) {
                this.applyQuotedLiteralSignature((CssPropertySignature.QuotedLiteralSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.SymbolSignature) {
                this.applySymbolSignature((CssPropertySignature.SymbolSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.PropertyRefSignature) {
                this.applyPropertyRefSignature((CssPropertySignature.PropertyRefSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.CallSignature) {
                this.applyCallSignature((CssPropertySignature.CallSignature)sig, candidate, propertyName, passed);
                continue;
            }
            if (sig instanceof CssPropertySignature.ProgIdSignature) {
                this.applyProgIdSignature((CssPropertySignature.ProgIdSignature)sig, candidate, propertyName, passed);
                continue;
            }
            throw new SomethingWidgyHappenedError(sig.getClass().getName());
        }
        for (Candidate candidate : passed) {
            if (null != this.best && this.best.exprIdx >= candidate.exprIdx) continue;
            this.best = candidate;
        }
        return passed;
    }

    private boolean checkEnd(Candidate candidate, CssPropertySignature sig, List<Candidate> passed) {
        if (candidate.exprIdx == this.expr.children().size()) {
            if (sig instanceof CssPropertySignature.RepeatedSignature && 0 == ((CssPropertySignature.RepeatedSignature)sig).minCount) {
                passed.add(candidate);
            }
            return true;
        }
        return false;
    }

    private void skipBlank(Candidate candidate) {
        CssTree child = this.expr.children().get(candidate.exprIdx);
        if (child instanceof CssTree.Operation && CssTree.Operator.NONE == ((CssTree.Operation)child).getOperator()) {
            ++candidate.exprIdx;
        }
    }

    private void applySetSignature(CssPropertySignature.SetSignature ssig, Candidate candidate, Name propertyName, List<Candidate> passed) {
        List<Candidate> toApply = Collections.singletonList(candidate);
        for (CssPropertySignature cssPropertySignature : ssig.children()) {
            List<Candidate> elementsPassed = this.applySignature(toApply, propertyName, cssPropertySignature);
            if (elementsPassed.isEmpty()) continue;
            passed.addAll(elementsPassed);
            break;
        }
    }

    private void applyExclusiveSetSignature(CssPropertySignature.ExclusiveSetSignature ssig, Candidate candidate, Name propertyName, BitSet used, List<Candidate> passed) {
        List<Candidate> toApply = Collections.singletonList(candidate);
        int k = -1;
        for (CssPropertySignature cssPropertySignature : ssig.children()) {
            List<Candidate> elementsPassed;
            if (used.get(++k) || (elementsPassed = this.applySignature(toApply, propertyName, cssPropertySignature)).isEmpty()) continue;
            passed.addAll(elementsPassed);
            used.set(k);
            break;
        }
    }

    private void applySeriesSignature(CssPropertySignature.SeriesSignature ssig, Candidate candidate, Name propertyName, List<Candidate> passed) {
        CssPropertySignature seriesElement;
        List<Candidate> toApply = Collections.singletonList(candidate);
        Iterator<? extends CssPropertySignature> i$ = ssig.children().iterator();
        while (i$.hasNext() && !(toApply = this.applySignature(toApply, propertyName, seriesElement = i$.next())).isEmpty()) {
        }
        passed.addAll(toApply);
    }

    private void applyRepeatedSignature(CssPropertySignature.RepeatedSignature rsig, Candidate candidate, Name propertyName, List<Candidate> passed) {
        int k;
        int MAX_BRANCHING_FACTOR = 6;
        List<Candidate> toApply = Collections.singletonList(candidate);
        for (k = 0; k < rsig.minCount && !(toApply = this.applySignature(toApply, propertyName, rsig.getRepeatedSignature())).isEmpty(); ++k) {
        }
        if (!toApply.isEmpty()) {
            CssPropertySignature repeated = rsig.getRepeatedSignature();
            BitSet used = null;
            if (repeated instanceof CssPropertySignature.ExclusiveSetSignature) {
                used = new BitSet(repeated.children().size());
            }
            toApply = new ArrayList<Candidate>(toApply);
            while (k < rsig.maxCount) {
                if (k < 6) {
                    passed.addAll(toApply);
                    int i = toApply.size();
                    while (--i >= 0) {
                        toApply.set(i, toApply.get(i).clone());
                    }
                }
                if (null == used) {
                    toApply = this.applySignature(toApply, propertyName, repeated);
                } else {
                    ArrayList<Candidate> passedSet = new ArrayList<Candidate>();
                    for (Candidate setCandidate : toApply) {
                        if (setCandidate.exprIdx == this.expr.children().size()) {
                            passed.add(setCandidate);
                            continue;
                        }
                        this.skipBlank(setCandidate);
                        this.applyExclusiveSetSignature((CssPropertySignature.ExclusiveSetSignature)repeated, setCandidate, propertyName, used, passedSet);
                    }
                    toApply = passedSet;
                }
                if (toApply.isEmpty()) break;
                ++k;
            }
            passed.addAll(toApply);
        }
    }

    private void applyLiteralSignature(CssPropertySignature.LiteralSignature literal, Candidate candidate, Name propertyName, List<Candidate> passed) {
        if (0 == (candidate.exprIdx & 1)) {
            boolean match;
            CssTree.Term term = (CssTree.Term)this.expr.children().get(candidate.exprIdx);
            CssTree.CssExprAtom atom = term.getExprAtom();
            if (null == term.getOperator() && (match = atom instanceof CssTree.IdentLiteral ? Strings.equalsIgnoreCase(literal.value, ((CssTree.IdentLiteral)atom).getValue()) : (atom instanceof CssTree.QuantityLiteral ? literal.value.equals(atom.getValue()) : false))) {
                candidate.match(term, CssPropertyPartType.IDENT, propertyName);
                ++candidate.exprIdx;
                passed.add(candidate);
            }
        } else {
            CssTree.Operation op = (CssTree.Operation)this.expr.children().get(candidate.exprIdx);
            if (op.getOperator().getSymbol().equals(literal.getValue())) {
                ++candidate.exprIdx;
                passed.add(candidate);
            }
        }
    }

    private void applyQuotedLiteralSignature(CssPropertySignature.QuotedLiteralSignature lit, Candidate candidate, Name propertyName, List<Candidate> passed) {
        if (0 == (candidate.exprIdx & 1)) {
            CssTree.Term term = (CssTree.Term)this.expr.children().get(candidate.exprIdx);
            CssTree.CssExprAtom atom = term.getExprAtom();
            if (null == term.getOperator() && atom instanceof CssTree.StringLiteral && lit.value.equals(((CssTree.StringLiteral)atom).getValue())) {
                candidate.match(term, CssPropertyPartType.STRING, propertyName);
                ++candidate.exprIdx;
                passed.add(candidate);
            }
        }
    }

    private void applySymbolSignature(CssPropertySignature.SymbolSignature ssig, Candidate candidate, Name propertyName, List<Candidate> passed) {
        CssSchema.SymbolInfo symbolInfo = this.cssSchema.getSymbol(ssig.symbolName);
        if (null != symbolInfo) {
            passed.addAll(this.applySignature(Collections.singletonList(candidate), Name.css(propertyName + "::" + symbolInfo.name), symbolInfo.sig));
        } else if (this.symbolMatch(candidate, propertyName, ssig)) {
            passed.add(candidate);
        }
    }

    private void applyPropertyRefSignature(CssPropertySignature.PropertyRefSignature ssig, Candidate candidate, Name propertyName, List<Candidate> passed) {
        CssSchema.CssPropertyInfo info = this.cssSchema.getCssProperty(ssig.getPropertyName());
        if (null == info) {
            throw new SomethingWidgyHappenedError("Unknown property in css property signature: " + propertyName);
        }
        SignatureResolver.check(info.sig);
        passed.addAll(this.applySignature(Collections.singletonList(candidate), info.name, info.sig));
    }

    private void applyCallSignature(CssPropertySignature.CallSignature call, Candidate candidate, Name propertyName, List<Candidate> passed) {
        if (0 == (candidate.exprIdx & 1)) {
            CssTree.FunctionCall fn;
            CssTree.Term term = (CssTree.Term)this.expr.children().get(candidate.exprIdx);
            CssTree.CssExprAtom atom = term.getExprAtom();
            if (null == term.getOperator() && atom instanceof CssTree.FunctionCall && (fn = (CssTree.FunctionCall)atom).getName().getCanonicalForm().equals(call.children().get(0).getValue())) {
                CssPropertySignature formals = call.children().get(1);
                CssTree.Expr actuals = fn.getArguments();
                Candidate inFnSpace = new Candidate(0, candidate.match, candidate.warning);
                for (Candidate resultInFnSpace : new SignatureResolver(actuals, this.cssSchema).applySignature(Collections.singletonList(inFnSpace), propertyName, formals)) {
                    passed.add(new Candidate(candidate.exprIdx + 1, resultInFnSpace.match, resultInFnSpace.warning));
                }
            }
        }
    }

    private void applyProgIdSignature(CssPropertySignature.ProgIdSignature progIdSig, Candidate candidate, Name propertyName, List<Candidate> passed) {
        if (0 == (candidate.exprIdx & 1)) {
            CssTree.Term term = (CssTree.Term)this.expr.children().get(candidate.exprIdx);
            CssTree.CssExprAtom atom = term.getExprAtom();
            if (null == term.getOperator() && atom instanceof CssTree.ProgId) {
                CssTree.ProgId progId = (CssTree.ProgId)atom;
                if (progIdSig.getName().equals(progId.getName())) {
                    Match match = candidate.match;
                    MessageSList warning = candidate.warning;
                    for (CssTree.ProgIdAttribute progIdAttribute : progId.children()) {
                        CssPropertySignature.ProgIdAttrSignature attrSig = progIdSig.getProgIdAttr(progIdAttribute.getName());
                        if (attrSig == null) {
                            return;
                        }
                        Candidate inAttrSpace = new Candidate(0, match, warning);
                        CssTree.Term value = progIdAttribute.getPropertyValue();
                        CssTree.Expr valueExpr = new CssTree.Expr(value.getFilePosition(), Collections.singletonList(value));
                        SignatureResolver sr = new SignatureResolver(valueExpr, this.cssSchema);
                        List<Candidate> resultInAttrSpaces = sr.applySignature(Collections.singletonList(inAttrSpace), propertyName, attrSig.getValueSig());
                        boolean matched = false;
                        for (Candidate c : resultInAttrSpaces) {
                            if (c.exprIdx != 1) continue;
                            match = c.match;
                            warning = c.warning;
                            matched = true;
                            break;
                        }
                        if (matched) continue;
                        return;
                    }
                    passed.add(new Candidate(candidate.exprIdx + 1, match, warning));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean symbolMatch(Candidate candidate, Name propertyName, CssPropertySignature.SymbolSignature sig) {
        char ch;
        int numEnd;
        String name;
        Object atomValue;
        String atomSValue;
        if (0 != (candidate.exprIdx & 1)) {
            return false;
        }
        CssTree.Term term = (CssTree.Term)this.expr.children().get(candidate.exprIdx);
        CssTree.CssExprAtom atom = term.getExprAtom();
        String symbolName = sig.symbolName.getCanonicalForm();
        String constraints = null;
        int colon = symbolName.indexOf(":");
        if (colon >= 0) {
            constraints = symbolName.substring(colon + 1);
            symbolName = symbolName.substring(0, colon);
        }
        String string = atomSValue = (atomValue = atom.getValue()) instanceof String ? (String)atomValue : "";
        if (atom instanceof CssTree.Substitution && term.getOperator() != null) {
            return false;
        }
        if ("length".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && LENGTH_RE.matcher(atomSValue).matches() || atom instanceof CssTree.Substitution && LENGTH_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.LENGTH, propertyName);
            ++candidate.exprIdx;
        } else if ("number".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && NUMBER_RE.matcher(atomSValue).matches() || atom instanceof CssTree.Substitution && NUMBER_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.NUMBER, propertyName);
            ++candidate.exprIdx;
        } else if ("integer".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && INTEGER_RE.matcher(atomSValue).matches() || atom instanceof CssTree.Substitution && NUMBER_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.INTEGER, propertyName);
            ++candidate.exprIdx;
        } else if ("percentage".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && PERCENTAGE_RE.matcher(atomSValue).matches() || atom instanceof CssTree.Substitution && PERCENTAGE_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.PERCENTAGE, propertyName);
            ++candidate.exprIdx;
        } else if ("unreserved-word".equals(symbolName)) {
            if (null != term.getOperator()) {
                return false;
            }
            if (!(atom instanceof CssTree.IdentLiteral)) return false;
            name = ((CssTree.IdentLiteral)atom).getValue();
            if (this.cssSchema.isKeyword(Name.css(name))) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.LOOSE_WORD, propertyName);
            ++candidate.exprIdx;
        } else if ("quotable-word".equals(symbolName)) {
            if (null != term.getOperator() || !(atom instanceof CssTree.IdentLiteral)) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.LOOSE_WORD, propertyName);
            ++candidate.exprIdx;
        } else if ("hex-color".equals(symbolName)) {
            if (atom instanceof CssTree.HashLiteral) {
                String hex = ((CssTree.HashLiteral)atom).getValue();
                if (hex.length() != 4 && hex.length() != 7) {
                    return false;
                }
                candidate.match(term, CssPropertyPartType.COLOR, propertyName);
                ++candidate.exprIdx;
            } else {
                if (!(atom instanceof CssTree.Substitution)) return false;
                if (!COLOR_SUFFIX_RE.matcher(atomSValue).find()) {
                    return false;
                }
                candidate.match(term, CssPropertyPartType.COLOR, propertyName);
                ++candidate.exprIdx;
            }
        } else if ("angle".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && ANGLE_RE.matcher(atomSValue).matches() || atom instanceof CssTree.Substitution && ANGLE_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.ANGLE, propertyName);
            ++candidate.exprIdx;
        } else if ("time".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && null == term.getOperator() && TIME_RE.matcher(atomSValue).matches() || atom instanceof CssTree.Substitution && TIME_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.TIME, propertyName);
            ++candidate.exprIdx;
        } else if ("frequency".equals(symbolName)) {
            if (!(atom instanceof CssTree.QuantityLiteral && null == term.getOperator() && FREQUENCY_RE.matcher(((CssTree.QuantityLiteral)atom).getValue()).matches() || atom instanceof CssTree.Substitution && FREQUENCY_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.FREQUENCY, propertyName);
            ++candidate.exprIdx;
        } else if ("specific-voice".equals(symbolName)) {
            if (null != term.getOperator()) {
                return false;
            }
            if (atom instanceof CssTree.IdentLiteral) {
                name = ((CssTree.IdentLiteral)atom).getValue();
                if (this.cssSchema.isKeyword(Name.css(name))) {
                    return false;
                }
            } else {
                if (!(atom instanceof CssTree.StringLiteral)) return false;
                name = ((CssTree.StringLiteral)atom).getValue();
            }
            if (!SPECIFIC_VOICE_RE.matcher(name).matches()) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.SPECIFIC_VOICE, propertyName);
            ++candidate.exprIdx;
        } else if ("uri".equals(symbolName)) {
            if (null != term.getOperator()) {
                return false;
            }
            if (!(atom instanceof CssTree.UriLiteral || atom instanceof CssTree.StringLiteral || atom instanceof CssTree.Substitution && URI_SUFFIX_RE.matcher(atomSValue).find())) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.URI, propertyName);
            ++candidate.exprIdx;
        } else if ("string".equals(symbolName)) {
            if (null != term.getOperator() || !(atom instanceof CssTree.StringLiteral)) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.STRING, propertyName);
            ++candidate.exprIdx;
        } else {
            if (!"identifier".equals(symbolName)) throw new SomethingWidgyHappenedError("unhandled symbol " + sig.symbolName + "\n" + SignatureResolver.dump(atom));
            if (null != term.getOperator() || !(atom instanceof CssTree.IdentLiteral)) {
                return false;
            }
            candidate.match(term, CssPropertyPartType.IDENT, propertyName);
            ++candidate.exprIdx;
        }
        if (null == constraints || atom instanceof CssTree.Substitution) return true;
        int comma = constraints.indexOf(",");
        double min = Double.parseDouble(constraints.substring(0, comma));
        double max = comma + 1 == constraints.length() ? Double.POSITIVE_INFINITY : Double.parseDouble(constraints.substring(comma + 1));
        String valueStr = ((CssTree.QuantityLiteral)atom).getValue();
        for (numEnd = 0; numEnd < valueStr.length() && ((ch = valueStr.charAt(numEnd)) >= '0' && ch <= '9' || ch == '.'); ++numEnd) {
        }
        double value = Double.parseDouble(valueStr.substring(0, numEnd));
        if (CssTree.UnaryOperator.NEGATION == term.getOperator()) {
            value *= -1.0;
        }
        if (!(value < min) && !(value > max)) return true;
        candidate.warn(PluginMessageType.CSS_VALUE_OUT_OF_RANGE, term.getFilePosition(), propertyName, MessagePart.Factory.valueOf(value), MessagePart.Factory.valueOf(min), MessagePart.Factory.valueOf(max));
        return true;
    }

    private static void check(ParseTreeNode node) {
    }

    private static String dump(ParseTreeNode node) {
        SignatureResolver.check(node);
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        mc.relevantKeys = Collections.singleton(NUM);
        try {
            node.formatTree(mc, 2, sb);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    static {
        COLOR_SUFFIX_RE = NUMBER_SUFFIX_RE = Pattern.compile("\\}$");
        ANGLE_SUFFIX_RE = Pattern.compile("\\}(?:deg|grad|rad)$", 2);
        TIME_SUFFIX_RE = Pattern.compile("\\}(?:ms|s)$", 2);
        FREQUENCY_SUFFIX_RE = Pattern.compile("\\}(?:hz|kHz)$", 2);
        URI_SUFFIX_RE = Pattern.compile("\\}(?:uri)?$", 2);
        NUM = new SyntheticAttributeKey<Integer>(Integer.class, "serialno");
        serialno = 0;
    }
}

