/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.render.TokenClassification;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Spacer {
    private FilePosition mark;
    private TokenClassification lastClass;
    private String lastToken;
    private boolean pendingSpace = false;
    private int lastLine = 1;
    private final List<String> outputTokens = new ArrayList<String>();
    private static final Set<String> KEYWORDS = new HashSet<String>();

    Spacer() {
    }

    List<String> getOutputTokens() {
        return this.outputTokens;
    }

    void processMark(FilePosition mark) {
        this.mark = mark;
    }

    void processToken(String text) {
        TokenClassification tClass = TokenClassification.classify(text);
        if (tClass == null) {
            return;
        }
        switch (tClass) {
            case LINEBREAK: {
                this.emit("\n");
                return;
            }
            case SPACE: {
                this.pendingSpace = true;
                return;
            }
            case COMMENT: {
                if (this.mark != null && this.lastLine != this.mark.startLineNo()) {
                    this.newline();
                    this.lastLine = this.mark.startLineNo();
                } else if ("/".equals(this.lastToken) || this.pendingSpace) {
                    this.space();
                }
                this.pendingSpace = false;
                this.emit(text);
                if (text.startsWith("//")) {
                    this.newline();
                    this.pendingSpace = false;
                } else {
                    this.pendingSpace = true;
                }
                return;
            }
        }
        boolean spaceBefore = this.pendingSpace;
        this.pendingSpace = false;
        boolean spaceAfter = false;
        if (tClass == this.lastClass) {
            spaceBefore = !"(".equals(this.lastToken);
        } else if (this.lastClass == TokenClassification.REGEX) {
            if (tClass == TokenClassification.OTHER || "/".equals(text)) {
                spaceBefore = true;
            }
        } else if (tClass == TokenClassification.REGEX && "/".equals(this.lastToken)) {
            spaceBefore = true;
        } else if (tClass == TokenClassification.OTHER && Character.isDigit(text.charAt(0)) && ".".equals(this.lastToken)) {
            spaceBefore = true;
        }
        if (tClass == TokenClassification.OTHER) {
            if ("}".equals(this.lastToken)) {
                spaceBefore = true;
            }
            if (this.isKeyword(text.toString())) {
                spaceAfter = true;
            }
        }
        if (text.length() == 1) {
            char ch0 = text.charAt(0);
            switch (ch0) {
                case '{': {
                    if (this.lastClass == TokenClassification.PUNCTUATION) {
                        if (":".equals(this.lastToken)) {
                            spaceBefore = true;
                        } else if (!")".equals(this.lastToken) && !"=".equals(this.lastToken)) {
                            spaceBefore = !"(".equals(this.lastToken) && !"[".equals(this.lastToken);
                        }
                    }
                    spaceAfter = true;
                    break;
                }
                case '[': {
                    if (")".equals(this.lastToken)) {
                        spaceBefore = false;
                    }
                    spaceAfter = true;
                    break;
                }
                case '(': {
                    if (!")".equals(this.lastToken)) break;
                    spaceBefore = false;
                    break;
                }
                case '}': {
                    spaceBefore = !"{".equals(this.lastToken);
                    spaceAfter = true;
                    break;
                }
                case ')': {
                    spaceBefore = false;
                    spaceAfter = true;
                    break;
                }
                case ']': {
                    spaceBefore = !"}".equals(this.lastToken);
                    spaceAfter = true;
                    break;
                }
                case ',': {
                    spaceBefore = false;
                    spaceAfter = true;
                    break;
                }
                case ';': {
                    spaceBefore = false;
                    spaceAfter = true;
                    break;
                }
                case ':': {
                    spaceBefore = ":".equals(this.lastToken);
                    spaceAfter = true;
                    break;
                }
                case '=': {
                    spaceBefore = true;
                    spaceAfter = true;
                    break;
                }
                case '.': {
                    spaceBefore = this.lastToken != null && (TokenClassification.isNumber(this.lastToken) || ".".equals(this.lastToken));
                    spaceAfter = false;
                }
            }
        }
        if (spaceBefore) {
            this.space();
        }
        this.emit(text);
        this.pendingSpace = spaceAfter;
        this.lastClass = tClass;
        this.lastToken = text;
        if (this.mark != null) {
            this.lastLine = this.mark.startLineNo();
        }
    }

    private boolean isKeyword(String s) {
        return KEYWORDS.contains(s);
    }

    private void emit(String s) {
        this.outputTokens.add(s);
    }

    private void newline() {
        if (this.outputTokens.isEmpty()) {
            return;
        }
        int lastIdx = this.outputTokens.size() - 1;
        String last = this.outputTokens.get(lastIdx);
        if (" ".equals(last)) {
            this.outputTokens.set(lastIdx, "\n");
        } else if (!"\n".equals(last)) {
            this.emit("\n");
        }
    }

    private void space() {
        if (this.outputTokens.isEmpty()) {
            return;
        }
        String last = this.outputTokens.get(this.outputTokens.size() - 1);
        if (!"\n".equals(last) && !" ".equals(last)) {
            this.emit(" ");
        }
    }

    static {
        for (Keyword kw : Keyword.values()) {
            KEYWORDS.add(kw.toString());
        }
    }
}

