/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContentType {
    CSS("text/css", "css", true),
    JS("text/javascript", "js", true),
    JSON("application/json", "json", true),
    HTML("text/html", "html", true),
    XML("application/xhtml+xml", "xhtml", true),
    ZIP("application/zip", "zip", false);

    public final String mimeType;
    public final String ext;
    public final boolean isText;
    private static final Map<String, ContentType> MIME_TYPES;

    private ContentType(String contentType, String ext, boolean isText) {
        this.mimeType = contentType;
        this.ext = ext;
        this.isText = isText;
    }

    public static ContentType fromMimeType(String mimeType) {
        int end = mimeType.indexOf(59);
        if (end >= 0) {
            while (end > 0 && Character.isWhitespace(mimeType.charAt(end))) {
                --end;
            }
        } else {
            end = mimeType.length();
        }
        return MIME_TYPES.get(Strings.toLowerCase(mimeType.substring(0, end)));
    }

    static {
        MIME_TYPES = Maps.immutableMap().put("text/javascript", JS).put("application/x-javascript", JS).put("application/javascript", JS).put("text/ecmascript", JS).put("application/ecmascript", JS).put("text/jscript", JS).put("application/json", JSON).put("text/css", CSS).put("text/html", HTML).put("application/xml", XML).put("application/xhtml+xml", XML).put("application/x-winzip", ZIP).put("application/zip", ZIP).put("application/x-java-archive", ZIP).create();
    }
}

